/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop;

import java.util.Date;
import java.util.List;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopDetectingStore
extends DelegatingStore<ByteArray, byte[]> {
    private final int replicationFactor;
    private final Node localNode;
    private final RoutingStrategy routingStrategy;
    private final Store<ByteArray, Slop> slopStore;

    public SlopDetectingStore(Store<ByteArray, byte[]> innerStore, Store<ByteArray, Slop> slopStore, int replicationFactor, Node localNode, RoutingStrategy routingStrategy) {
        super(innerStore);
        this.replicationFactor = replicationFactor;
        this.localNode = Utils.notNull(localNode);
        this.routingStrategy = Utils.notNull(routingStrategy);
        this.slopStore = Utils.notNull(slopStore);
    }

    private boolean isLocal(ByteArray key) {
        List<Node> nodes = this.routingStrategy.routeRequest(key.get());
        int index = nodes.indexOf(this.localNode);
        return index >= 0 && index < this.replicationFactor;
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        if (this.isLocal(key)) {
            return this.getInnerStore().delete(key, version);
        }
        Slop slop = new Slop(this.getName(), Slop.Operation.DELETE, key, null, this.localNode.getId(), new Date());
        this.slopStore.put(slop.makeKey(), new Versioned<Slop>(slop, version));
        return false;
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        if (this.isLocal(key)) {
            this.getInnerStore().put(key, value);
        } else {
            Slop slop = new Slop(this.getName(), Slop.Operation.PUT, key, value.getValue(), this.localNode.getId(), new Date());
            this.slopStore.put(slop.makeKey(), new Versioned<Slop>(slop, value.getVersion()));
        }
    }
}

