/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;
import voldemort.VoldemortApplicationException;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.store.routed.NodeValue;
import voldemort.store.routed.ReadRepairer;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutedStore
implements Store<ByteArray, byte[]> {
    private static final Logger logger = Logger.getLogger(RoutedStore.class.getName());
    private static final StoreOp<Versioned<byte[]>> VERSIONED_OP = new StoreOp<Versioned<byte[]>>(){

        @Override
        public List<Versioned<byte[]>> execute(Store<ByteArray, byte[]> store, ByteArray key) {
            return store.get(key);
        }
    };
    private static final StoreOp<Version> VERSION_OP = new StoreOp<Version>(){

        @Override
        public List<Version> execute(Store<ByteArray, byte[]> store, ByteArray key) {
            return store.getVersions(key);
        }
    };
    private final String name;
    private final Map<Integer, Store<ByteArray, byte[]>> innerStores;
    private final ExecutorService executor;
    private final boolean repairReads;
    private final ReadRepairer<ByteArray, byte[]> readRepairer;
    private final long timeoutMs;
    private final Time time;
    private final StoreDefinition storeDef;
    private final FailureDetector failureDetector;
    private volatile RoutingStrategy routingStrategy;

    public RoutedStore(String name, Map<Integer, Store<ByteArray, byte[]>> innerStores, Cluster cluster, StoreDefinition storeDef, int numberOfThreads, boolean repairReads, long timeoutMs, FailureDetector failureDetector) {
        this(name, innerStores, cluster, storeDef, repairReads, Executors.newFixedThreadPool(numberOfThreads), timeoutMs, failureDetector, SystemTime.INSTANCE);
    }

    public RoutedStore(String name, Map<Integer, Store<ByteArray, byte[]>> innerStores, Cluster cluster, StoreDefinition storeDef, boolean repairReads, ExecutorService threadPool, long timeoutMs, FailureDetector failureDetector, Time time) {
        if (storeDef.getRequiredReads() < 1) {
            throw new IllegalArgumentException("Cannot have a storeDef.getRequiredReads() number less than 1.");
        }
        if (storeDef.getRequiredWrites() < 1) {
            throw new IllegalArgumentException("Cannot have a storeDef.getRequiredWrites() number less than 1.");
        }
        if (storeDef.getPreferredReads() < storeDef.getRequiredReads()) {
            throw new IllegalArgumentException("storeDef.getPreferredReads() must be greater or equal to storeDef.getRequiredReads().");
        }
        if (storeDef.getPreferredWrites() < storeDef.getRequiredWrites()) {
            throw new IllegalArgumentException("storeDef.getPreferredWrites() must be greater or equal to storeDef.getRequiredWrites().");
        }
        if (storeDef.getPreferredReads() > innerStores.size()) {
            throw new IllegalArgumentException("storeDef.getPreferredReads() is larger than the total number of nodes!");
        }
        if (storeDef.getPreferredWrites() > innerStores.size()) {
            throw new IllegalArgumentException("storeDef.getPreferredWrites() is larger than the total number of nodes!");
        }
        this.name = name;
        this.innerStores = new ConcurrentHashMap<Integer, Store<ByteArray, byte[]>>(innerStores);
        this.repairReads = repairReads;
        this.executor = threadPool;
        this.readRepairer = new ReadRepairer();
        this.timeoutMs = timeoutMs;
        this.time = Utils.notNull(time);
        this.storeDef = storeDef;
        this.failureDetector = failureDetector;
        this.routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDef, cluster);
    }

    public void updateRoutingStrategy(RoutingStrategy routingStrategy) {
        logger.info("Updating routing strategy for RoutedStore:" + this.getName());
        this.routingStrategy = routingStrategy;
    }

    @Override
    public boolean delete(final ByteArray key, final Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        List<Node> nodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
        int numNodes = nodes.size();
        if (numNodes < this.storeDef.getRequiredWrites()) {
            throw new InsufficientOperationalNodesException("Only " + numNodes + " nodes in preference list, but " + this.storeDef.getRequiredWrites() + " writes required.");
        }
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicBoolean deletedSomething = new AtomicBoolean(false);
        final List failures = Collections.synchronizedList(new LinkedList());
        final Semaphore semaphore = new Semaphore(0, false);
        for (final Node node : nodes) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    long startNs = System.nanoTime();
                    try {
                        boolean deleted = ((Store)RoutedStore.this.innerStores.get(node.getId())).delete(key, version);
                        successes.incrementAndGet();
                        deletedSomething.compareAndSet(false, deleted);
                        RoutedStore.this.recordSuccess(node, startNs);
                    }
                    catch (UnreachableStoreException e) {
                        failures.add(e);
                        RoutedStore.this.recordException(node, startNs, e);
                    }
                    catch (VoldemortApplicationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        failures.add(e);
                        logger.warn("Error in DELETE on node " + node.getId() + "(" + node.getHost() + ")", e);
                    }
                    finally {
                        semaphore.release();
                    }
                }
            });
        }
        int attempts = Math.min(this.storeDef.getPreferredWrites(), numNodes);
        if (this.storeDef.getPreferredWrites() <= 0) {
            return true;
        }
        for (int i = 0; i < numNodes; ++i) {
            try {
                boolean acquired = semaphore.tryAcquire(this.timeoutMs, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    logger.warn("Delete operation timed out waiting for operation " + i + " to complete after waiting " + this.timeoutMs + " ms.");
                }
                if (successes.get() < attempts) continue;
                return deletedSomething.get();
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("Delete operation interrupted!", e);
            }
        }
        if (successes.get() < this.storeDef.getRequiredWrites()) {
            throw new InsufficientOperationalNodesException(this.storeDef.getRequiredWrites() + " deletes required, but " + successes.get() + " succeeded.", failures);
        }
        return deletedSomething.get();
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        List futures;
        StoreUtils.assertValidKeys(keys);
        HashMap<ByteArray, List<Versioned<byte[]>>> result = StoreUtils.newEmptyHashMap(keys);
        HashMap nodeToKeysMap = Maps.newHashMap();
        HashMap keyToExtraNodesMap = Maps.newHashMap();
        for (ByteArray key : keys) {
            List<Node> availableNodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
            this.checkRequiredReads(availableNodes);
            int preferredReads = this.storeDef.getPreferredReads();
            ArrayList<Node> preferredNodes = Lists.newArrayListWithCapacity(preferredReads);
            ArrayList<Node> extraNodes = Lists.newArrayListWithCapacity(3);
            for (Node node : availableNodes) {
                if (preferredNodes.size() < preferredReads) {
                    preferredNodes.add(node);
                    continue;
                }
                extraNodes.add(node);
            }
            for (Node node : preferredNodes) {
                ArrayList<ByteArray> nodeKeys = (ArrayList<ByteArray>)nodeToKeysMap.get(node);
                if (nodeKeys == null) {
                    nodeKeys = Lists.newArrayList();
                    nodeToKeysMap.put(node, nodeKeys);
                }
                nodeKeys.add(key);
            }
            if (extraNodes.isEmpty()) continue;
            List list = (List)keyToExtraNodesMap.get(key);
            if (list == null) {
                keyToExtraNodesMap.put(key, extraNodes);
                continue;
            }
            list.addAll(extraNodes);
        }
        ArrayList<GetAllCallable> callables = Lists.newArrayList();
        for (Map.Entry entry : nodeToKeysMap.entrySet()) {
            Node node = (Node)entry.getKey();
            Collection nodeKeys = (Collection)entry.getValue();
            if (!this.failureDetector.isAvailable(node)) continue;
            callables.add(new GetAllCallable(node, nodeKeys));
        }
        ArrayList<Throwable> failures = Lists.newArrayList();
        ArrayList<NodeValue<ByteArray, byte[]>> nodeValues = Lists.newArrayList();
        HashMap<ByteArray, MutableInt> keyToSuccessCount = Maps.newHashMap();
        for (ByteArray key : keys) {
            keyToSuccessCount.put(key, new MutableInt(0));
        }
        try {
            futures = this.executor.invokeAll(callables, this.timeoutMs * 3L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InsufficientOperationalNodesException("getAll operation interrupted.", e);
        }
        for (Future future : futures) {
            if (future.isCancelled()) {
                logger.warn("Get operation timed out after " + this.timeoutMs + " ms.");
                continue;
            }
            try {
                GetAllResult getResult = (GetAllResult)future.get();
                if (getResult.exception != null) {
                    if (getResult.exception instanceof VoldemortApplicationException) {
                        throw (VoldemortException)getResult.exception;
                    }
                    failures.add(getResult.exception);
                    continue;
                }
                for (ByteArray key : getResult.callable.nodeKeys) {
                    List<Versioned<byte[]>> retrieved = getResult.retrieved.get(key);
                    MutableInt successCount = (MutableInt)keyToSuccessCount.get(key);
                    successCount.increment();
                    if (retrieved == null) continue;
                    List existing = (List)result.get(key);
                    if (existing == null) {
                        result.put(key, Lists.newArrayList(retrieved));
                        continue;
                    }
                    existing.addAll(retrieved);
                }
                nodeValues.addAll(getResult.nodeValues);
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("getAll operation interrupted.", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                logger.error(e.getMessage(), e);
            }
        }
        for (ByteArray byteArray : keys) {
            List extraNodes;
            MutableInt successCountWrapper = (MutableInt)keyToSuccessCount.get(byteArray);
            int successCount = successCountWrapper.intValue();
            if (successCount < this.storeDef.getPreferredReads() && (extraNodes = (List)keyToExtraNodesMap.get(byteArray)) != null) {
                for (Node node : extraNodes) {
                    long startNs = System.nanoTime();
                    try {
                        List<Versioned<byte[]>> values = this.innerStores.get(node.getId()).get(byteArray);
                        this.fillRepairReadsValues(nodeValues, byteArray, node, values);
                        List versioneds = (List)result.get(byteArray);
                        if (versioneds == null) {
                            result.put(byteArray, Lists.newArrayList(values));
                        } else {
                            versioneds.addAll(values);
                        }
                        this.recordSuccess(node, startNs);
                        if (++successCount < this.storeDef.getPreferredReads()) continue;
                        break;
                    }
                    catch (UnreachableStoreException e) {
                        failures.add(e);
                        this.recordException(node, startNs, e);
                    }
                    catch (VoldemortApplicationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.warn("Error in GET_ALL on node " + node.getId() + "(" + node.getHost() + ")", e);
                        failures.add(e);
                    }
                }
            }
            successCountWrapper.setValue(successCount);
        }
        this.repairReads(nodeValues);
        for (Map.Entry entry : keyToSuccessCount.entrySet()) {
            int successCount = ((MutableInt)entry.getValue()).intValue();
            if (successCount >= this.storeDef.getRequiredReads()) continue;
            throw new InsufficientOperationalNodesException(this.storeDef.getRequiredReads() + " reads required, but " + successCount + " succeeded.", failures);
        }
        return result;
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) {
        Function<List<GetResult<Versioned<byte[]>>>, Void> readRepairFunction = new Function<List<GetResult<Versioned<byte[]>>>, Void>(){

            @Override
            public Void apply(List<GetResult<Versioned<byte[]>>> nodeResults) {
                ArrayList nodeValues = Lists.newArrayListWithExpectedSize(nodeResults.size());
                for (GetResult<Versioned<byte[]>> getResult : nodeResults) {
                    RoutedStore.this.fillRepairReadsValues(nodeValues, getResult.key, getResult.node, getResult.retrieved);
                }
                RoutedStore.this.repairReads(nodeValues);
                return null;
            }
        };
        return this.get(key, VERSIONED_OP, readRepairFunction);
    }

    private <R> List<R> get(ByteArray key, StoreOp<R> fetcher, Function<List<GetResult<R>>, Void> preReturnProcedure) throws VoldemortException {
        List futures;
        int nodeIndex;
        StoreUtils.assertValidKey(key);
        List<Node> nodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
        this.checkRequiredReads(nodes);
        ArrayList<GetResult<R>> retrieved = Lists.newArrayList();
        int successes = 0;
        ArrayList<Throwable> failures = Lists.newArrayListWithCapacity(3);
        int attempts = Math.min(this.storeDef.getPreferredReads(), nodes.size());
        ArrayList<GetCallable<R>> callables = Lists.newArrayListWithCapacity(attempts);
        for (nodeIndex = 0; nodeIndex < attempts; ++nodeIndex) {
            Node node = nodes.get(nodeIndex);
            callables.add(new GetCallable<R>(node, key, fetcher));
        }
        try {
            futures = this.executor.invokeAll(callables, this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InsufficientOperationalNodesException("Get operation interrupted!", e);
        }
        for (Future f : futures) {
            if (f.isCancelled()) {
                logger.warn("Get operation timed out after " + this.timeoutMs + " ms.");
                continue;
            }
            try {
                GetResult getResult = (GetResult)f.get();
                if (getResult.exception != null) {
                    if (getResult.exception instanceof VoldemortApplicationException) {
                        throw (VoldemortException)getResult.exception;
                    }
                    failures.add(getResult.exception);
                    continue;
                }
                ++successes;
                retrieved.add(getResult);
            }
            catch (InterruptedException interruptedException) {
                throw new InsufficientOperationalNodesException("Get operation interrupted!", interruptedException);
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof Error) {
                    throw (Error)executionException.getCause();
                }
                logger.error(executionException.getMessage(), executionException);
            }
        }
        while (successes < this.storeDef.getPreferredReads() && nodeIndex < nodes.size()) {
            Node node = nodes.get(nodeIndex);
            long startNs = System.nanoTime();
            try {
                retrieved.add(new GetResult<R>(node, key, fetcher.execute(this.innerStores.get(node.getId()), key), null));
                ++successes;
                this.recordSuccess(node, startNs);
            }
            catch (UnreachableStoreException e) {
                failures.add(e);
                this.recordException(node, startNs, e);
            }
            catch (VoldemortApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                logger.warn("Error in GET on node " + node.getId() + "(" + node.getHost() + ")", e);
                failures.add(e);
            }
            ++nodeIndex;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("GET retrieved the following node values: " + this.formatNodeValues(retrieved));
        }
        if (preReturnProcedure != null) {
            preReturnProcedure.apply(retrieved);
        }
        if (successes >= this.storeDef.getRequiredReads()) {
            ArrayList result = Lists.newArrayListWithExpectedSize(retrieved.size());
            for (GetResult getResult : retrieved) {
                result.addAll(getResult.retrieved);
            }
            return result;
        }
        throw new InsufficientOperationalNodesException(this.storeDef.getRequiredReads() + " reads required, but " + successes + " succeeded.", failures);
    }

    private void fillRepairReadsValues(List<NodeValue<ByteArray, byte[]>> nodeValues, ByteArray key, Node node, List<Versioned<byte[]>> fetched) {
        if (this.repairReads) {
            if (fetched.size() == 0) {
                nodeValues.add(this.nullValue(node, key));
            } else {
                for (Versioned<byte[]> f : fetched) {
                    nodeValues.add(new NodeValue<ByteArray, byte[]>(node.getId(), key, f));
                }
            }
        }
    }

    private NodeValue<ByteArray, byte[]> nullValue(Node node, ByteArray key) {
        return new NodeValue<ByteArray, Object>(node.getId(), key, new Versioned<Object>(null));
    }

    private void repairReads(List<NodeValue<ByteArray, byte[]>> nodeValues) {
        if (!this.repairReads || nodeValues.size() <= 1 || this.storeDef.getPreferredReads() <= 1) {
            return;
        }
        final ArrayList<NodeValue<ByteArray, byte[]>> toReadRepair = Lists.newArrayList();
        for (NodeValue<ByteArray, byte[]> v : this.readRepairer.getRepairs(nodeValues)) {
            Versioned<byte[]> versioned = Versioned.value(v.getVersioned().getValue(), ((VectorClock)v.getVersion()).clone());
            toReadRepair.add(new NodeValue<ByteArray, byte[]>(v.getNodeId(), v.getKey(), versioned));
        }
        this.executor.execute(new Runnable(){

            public void run() {
                for (NodeValue v : toReadRepair) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Doing read repair on node " + v.getNodeId() + " for key '" + v.getKey() + "' with version " + v.getVersion() + ".");
                        }
                        ((Store)RoutedStore.this.innerStores.get(v.getNodeId())).put(v.getKey(), v.getVersioned());
                    }
                    catch (VoldemortApplicationException e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Read repair cancelled due to application level exception on node " + v.getNodeId() + " for key '" + v.getKey() + "' with version " + v.getVersion() + ": " + e.getMessage());
                    }
                    catch (Exception e) {
                        logger.debug("Read repair failed: ", e);
                    }
                }
            }
        });
    }

    private void checkRequiredReads(List<Node> nodes) throws InsufficientOperationalNodesException {
        if (nodes.size() < this.storeDef.getRequiredReads()) {
            throw new InsufficientOperationalNodesException("Only " + nodes.size() + " nodes in preference list, but " + this.storeDef.getRequiredReads() + " reads required.");
        }
    }

    private <R> String formatNodeValues(List<GetResult<R>> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (GetResult<R> r : results) {
            builder.append("GetResult(nodeId=" + r.node.getId() + ", key=" + r.key + ", retrieved= " + r.retrieved + ")");
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void put(final ByteArray key, Versioned<byte[]> versioned) throws VoldemortException {
        int currentNode;
        long startNs = System.nanoTime();
        StoreUtils.assertValidKey(key);
        List<Node> nodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
        int numNodes = nodes.size();
        if (numNodes < this.storeDef.getRequiredWrites()) {
            throw new InsufficientOperationalNodesException("Only " + numNodes + " nodes in preference list, but " + this.storeDef.getRequiredWrites() + " writes required.");
        }
        final AtomicInteger successes = new AtomicInteger(0);
        final List<Exception> failures = Collections.synchronizedList(new ArrayList(1));
        Node master = null;
        Versioned<byte[]> versionedCopy = null;
        for (currentNode = 0; currentNode < numNodes; ++currentNode) {
            Node current = nodes.get(currentNode);
            long startNsLocal = System.nanoTime();
            try {
                versionedCopy = this.incremented(versioned, current.getId());
                this.innerStores.get(current.getId()).put(key, versionedCopy);
                successes.getAndIncrement();
                this.recordSuccess(current, startNsLocal);
                master = current;
                break;
            }
            catch (UnreachableStoreException e) {
                this.recordException(current, startNsLocal, e);
                failures.add(e);
                continue;
            }
            catch (VoldemortApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                failures.add(e);
            }
        }
        if (successes.get() < 1) {
            throw new InsufficientOperationalNodesException("No master node succeeded!", failures.size() > 0 ? (Exception)failures.get(0) : null);
        }
        ++currentNode;
        final Versioned<byte[]> finalVersionedCopy = versionedCopy;
        final Semaphore semaphore = new Semaphore(0, false);
        int attempts = 0;
        while (currentNode < numNodes) {
            ++attempts;
            final Node node = nodes.get(currentNode);
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    long startNsLocal = System.nanoTime();
                    try {
                        ((Store)RoutedStore.this.innerStores.get(node.getId())).put(key, finalVersionedCopy);
                        successes.incrementAndGet();
                        RoutedStore.this.recordSuccess(node, startNsLocal);
                    }
                    catch (UnreachableStoreException e) {
                        RoutedStore.this.recordException(node, startNsLocal, e);
                        failures.add(e);
                    }
                    catch (ObsoleteVersionException e) {
                    }
                    catch (VoldemortApplicationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        logger.warn("Error in PUT on node " + node.getId() + "(" + node.getHost() + ")", e);
                        failures.add(e);
                    }
                    finally {
                        semaphore.release();
                    }
                }
            });
            ++currentNode;
        }
        int blockCount = Math.min(this.storeDef.getPreferredWrites() - 1, attempts);
        boolean noTimeout = this.blockOnPut(startNs, semaphore, 0, blockCount, successes, this.storeDef.getPreferredWrites());
        if (successes.get() < this.storeDef.getRequiredWrites()) {
            if (noTimeout) {
                int startingIndex = blockCount - 1;
                blockCount = Math.max(this.storeDef.getPreferredWrites() - 1, attempts);
                this.blockOnPut(startNs, semaphore, startingIndex, blockCount, successes, this.storeDef.getRequiredWrites());
            }
            if (successes.get() < this.storeDef.getRequiredWrites()) {
                throw new InsufficientOperationalNodesException(successes.get() + " writes succeeded, but " + this.storeDef.getRequiredWrites() + " are required.", failures);
            }
        }
        VectorClock versionedClock = (VectorClock)versioned.getVersion();
        versionedClock.incrementVersion(master.getId(), this.time.getMilliseconds());
    }

    private boolean blockOnPut(long startNs, Semaphore semaphore, int startingIndex, int blockCount, AtomicInteger successes, int successesRequired) {
        for (int i = startingIndex; i < blockCount; ++i) {
            try {
                long ellapsedNs = System.nanoTime() - startNs;
                long remainingNs = this.timeoutMs * 1000000L - ellapsedNs;
                boolean acquiredPermit = semaphore.tryAcquire(Math.max(remainingNs, 0L), TimeUnit.NANOSECONDS);
                if (!acquiredPermit) {
                    logger.warn("Timed out waiting for put # " + (i + 1) + " of " + blockCount + " to succeed.");
                    return false;
                }
                if (successes.get() < successesRequired) continue;
                break;
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("Put operation interrupted", e);
            }
        }
        return true;
    }

    private Versioned<byte[]> incremented(Versioned<byte[]> versioned, int nodeId) {
        return new Versioned<byte[]>(versioned.getValue(), ((VectorClock)versioned.getVersion()).incremented(nodeId, this.time.getMilliseconds()));
    }

    private List<Node> availableNodes(List<Node> list) {
        ArrayList<Node> available = new ArrayList<Node>(list.size());
        for (Node node : list) {
            if (!this.failureDetector.isAvailable(node)) continue;
            available.add(node);
        }
        return available;
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
        VoldemortException exception = null;
        for (Store<ByteArray, byte[]> client : this.innerStores.values()) {
            try {
                client.close();
            }
            catch (VoldemortException v) {
                exception = v;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public Map<Integer, Store<ByteArray, byte[]>> getInnerStores() {
        return this.innerStores;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        switch (capability) {
            case ROUTING_STRATEGY: {
                return this.routingStrategy;
            }
            case READ_REPAIRER: {
                return this.readRepairer;
            }
            case VERSION_INCREMENTING: {
                return true;
            }
        }
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.get(key, VERSION_OP, null);
    }

    private void recordException(Node node, long startNs, UnreachableStoreException e) {
        this.failureDetector.recordException(node, (System.nanoTime() - startNs) / 1000000L, e);
    }

    private void recordSuccess(Node node, long startNs) {
        this.failureDetector.recordSuccess(node, (System.nanoTime() - startNs) / 1000000L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StoreOp<R> {
        public List<R> execute(Store<ByteArray, byte[]> var1, ByteArray var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetAllResult {
        final GetAllCallable callable;
        final Map<ByteArray, List<Versioned<byte[]>>> retrieved;
        final Throwable exception;
        final List<NodeValue<ByteArray, byte[]>> nodeValues;

        private GetAllResult(GetAllCallable callable, Map<ByteArray, List<Versioned<byte[]>>> retrieved, List<NodeValue<ByteArray, byte[]>> nodeValues, Throwable exception) {
            this.callable = callable;
            this.exception = exception;
            this.retrieved = retrieved;
            this.nodeValues = nodeValues;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GetAllCallable
    implements Callable<GetAllResult> {
        private final Node node;
        private final Collection<ByteArray> nodeKeys;

        private GetAllCallable(Node node, Collection<ByteArray> nodeKeys) {
            this.node = node;
            this.nodeKeys = nodeKeys;
        }

        @Override
        public GetAllResult call() {
            Map<Object, Object> retrieved = Collections.emptyMap();
            Throwable exception = null;
            ArrayList nodeValues = Lists.newArrayList();
            long startNs = System.nanoTime();
            try {
                retrieved = ((Store)RoutedStore.this.innerStores.get(this.node.getId())).getAll(this.nodeKeys);
                if (RoutedStore.this.repairReads) {
                    for (Map.Entry<Object, Object> entry : retrieved.entrySet()) {
                        RoutedStore.this.fillRepairReadsValues(nodeValues, (ByteArray)entry.getKey(), this.node, (List)entry.getValue());
                    }
                    for (ByteArray nodeKey : this.nodeKeys) {
                        if (retrieved.containsKey(nodeKey)) continue;
                        RoutedStore.this.fillRepairReadsValues(nodeValues, nodeKey, this.node, Collections.emptyList());
                    }
                }
                RoutedStore.this.recordSuccess(this.node, startNs);
            }
            catch (UnreachableStoreException e) {
                exception = e;
                RoutedStore.this.recordException(this.node, startNs, e);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                exception = e;
                logger.warn("Error in GET on node " + this.node.getId() + "(" + this.node.getHost() + ")", e);
            }
            return new GetAllResult(this, retrieved, nodeValues, exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetResult<R> {
        final Node node;
        final ByteArray key;
        final List<R> retrieved;
        final Throwable exception;

        public GetResult(Node node, ByteArray key, List<R> retrieved, Throwable exception) {
            this.node = node;
            this.key = key;
            this.retrieved = retrieved;
            this.exception = exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GetCallable<R>
    implements Callable<GetResult<R>> {
        private final Node node;
        private final ByteArray key;
        private final StoreOp<R> fetcher;

        public GetCallable(Node node, ByteArray key, StoreOp<R> fetcher) {
            this.node = node;
            this.key = key;
            this.fetcher = fetcher;
        }

        @Override
        public GetResult<R> call() throws Exception {
            List<Object> fetched = Collections.emptyList();
            Throwable exception = null;
            long startNs = System.nanoTime();
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("Attempting get operation on node " + this.node.getId() + " for key '" + ByteUtils.toHexString(this.key.get()) + "'.");
                }
                fetched = this.fetcher.execute((Store)RoutedStore.this.innerStores.get(this.node.getId()), this.key);
                RoutedStore.this.recordSuccess(this.node, startNs);
            }
            catch (UnreachableStoreException e) {
                exception = e;
                RoutedStore.this.recordException(this.node, startNs, e);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                logger.warn("Error in GET on node " + this.node.getId() + "(" + this.node.getHost() + ")", e);
                exception = e;
            }
            return new GetResult(this.node, this.key, fetched, exception);
        }
    }
}

