/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NodeValue<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int nodeId;
    private final K key;
    private final Versioned<V> value;

    public NodeValue(int nodeId, K key, Versioned<V> value) {
        this.nodeId = nodeId;
        this.key = Preconditions.checkNotNull(key);
        this.value = Preconditions.checkNotNull(value);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public K getKey() {
        return this.key;
    }

    public Versioned<V> getVersioned() {
        return this.value;
    }

    public Version getVersion() {
        return this.value.getVersion();
    }

    public NodeValue<K, V> clone() {
        return new NodeValue<K, V>(this.nodeId, this.key, this.value);
    }

    public String toString() {
        return "NodeValue(id=" + this.nodeId + ", key=" + this.key + ", versioned= " + this.value + ")";
    }

    public int hashCode() {
        return Objects.hashCode(this.nodeId, this.key, this.value.getVersion());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeValue)) {
            return false;
        }
        NodeValue v = (NodeValue)o;
        return this.getNodeId() == v.getNodeId() && Objects.equal(this.getKey(), v.getKey()) && Objects.equal(this.getVersion(), v.getVersion());
    }
}

