/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.rebalancing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.store.DelegatingStore;
import voldemort.store.InvalidMetadataException;
import voldemort.store.Store;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.routed.RoutedStore;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketPool;
import voldemort.store.socket.SocketStore;
import voldemort.utils.ByteArray;
import voldemort.utils.RebalanceUtils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebootstrappingStore
extends DelegatingStore<ByteArray, byte[]> {
    private final int maxMetadataRefreshAttempts = 3;
    private final MetadataStore metadata;
    private final StoreRepository storeRepository;
    private final VoldemortConfig voldemortConfig;
    private final SocketPool socketPool;
    private RoutedStore routedStore;

    public RebootstrappingStore(MetadataStore metadataStore, StoreRepository storeRepository, VoldemortConfig voldemortConfig, SocketPool socketPool, RoutedStore routedStore) {
        super(routedStore);
        this.metadata = metadataStore;
        this.storeRepository = storeRepository;
        this.voldemortConfig = voldemortConfig;
        this.socketPool = socketPool;
        this.routedStore = routedStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        AdminClient adminClient = RebalanceUtils.createTempAdminClient(this.voldemortConfig, this.metadata.getCluster(), 4, 2);
        try {
            Versioned<Cluster> latestCluster = RebalanceUtils.getLatestCluster(new ArrayList<Integer>(), adminClient);
            this.metadata.put("cluster.xml", latestCluster.getValue());
            this.checkAndAddNodeStore();
            this.routedStore.updateRoutingStrategy(this.metadata.getRoutingStrategy(this.getName()));
        }
        finally {
            adminClient.stop();
        }
    }

    private void checkAndAddNodeStore() {
        for (Node node : this.metadata.getCluster().getNodes()) {
            if (this.routedStore.getInnerStores().containsKey(node.getId())) continue;
            if (!this.storeRepository.hasNodeStore(this.getName(), node.getId())) {
                this.storeRepository.addNodeStore(node.getId(), this.createNodeStore(node));
            }
            this.routedStore.getInnerStores().put(node.getId(), this.storeRepository.getNodeStore(this.getName(), node.getId()));
        }
    }

    private Store<ByteArray, byte[]> createNodeStore(Node node) {
        return new SocketStore(this.getName(), new SocketDestination(node.getHost(), node.getSocketPort(), this.voldemortConfig.getRequestFormatType()), this.socketPool, false);
    }

    @Override
    public boolean delete(ByteArray key, Version version) {
        for (int attempts = 0; attempts < this.maxMetadataRefreshAttempts; ++attempts) {
            try {
                return super.delete(key, version);
            }
            catch (InvalidMetadataException e) {
                this.reinit();
                continue;
            }
        }
        throw new VoldemortException(this.maxMetadataRefreshAttempts + " metadata refresh attempts failed for server side routing.");
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        for (int attempts = 0; attempts < this.maxMetadataRefreshAttempts; ++attempts) {
            try {
                return super.getVersions(key);
            }
            catch (InvalidMetadataException e) {
                this.reinit();
                continue;
            }
        }
        throw new VoldemortException(this.maxMetadataRefreshAttempts + " metadata refresh attempts failed for server side routing.");
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) {
        for (int attempts = 0; attempts < this.maxMetadataRefreshAttempts; ++attempts) {
            try {
                return super.get(key);
            }
            catch (InvalidMetadataException e) {
                this.reinit();
                continue;
            }
        }
        throw new VoldemortException(this.maxMetadataRefreshAttempts + " metadata refresh attempts failed for server side routing.");
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) {
        for (int attempts = 0; attempts < this.maxMetadataRefreshAttempts; ++attempts) {
            try {
                return super.getAll(keys);
            }
            catch (InvalidMetadataException e) {
                this.reinit();
                continue;
            }
        }
        throw new VoldemortException(this.maxMetadataRefreshAttempts + " metadata refresh attempts failed for server side routing.");
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> versioned) throws ObsoleteVersionException {
        for (int attempts = 0; attempts < this.maxMetadataRefreshAttempts; ++attempts) {
            try {
                super.put(key, versioned);
                return;
            }
            catch (InvalidMetadataException e) {
                this.reinit();
                continue;
            }
        }
        throw new VoldemortException(this.maxMetadataRefreshAttempts + " metadata refresh attempts failed for server side routing.");
    }
}

