/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.utils.CmdUtils;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSwapper {
    private static final Logger logger = Logger.getLogger(StoreSwapper.class);
    private final Cluster cluster;
    private final ExecutorService executor;
    private final HttpClient httpClient;
    private final String readOnlyMgmtPath;

    public StoreSwapper(Cluster cluster, ExecutorService executor, HttpClient httpClient, String readOnlyMgmtPath) {
        this.cluster = cluster;
        this.executor = executor;
        this.httpClient = httpClient;
        this.readOnlyMgmtPath = readOnlyMgmtPath;
    }

    public void swapStoreData(String storeName, String basePath) {
        List<String> fetched = this.invokeFetch(storeName, basePath);
        this.invokeSwap(storeName, fetched);
    }

    private List<String> invokeFetch(final String storeName, final String basePath) {
        HashMap<Integer, Future<String>> fetchDirs = new HashMap<Integer, Future<String>>();
        for (final Node node : this.cluster.getNodes()) {
            fetchDirs.put(node.getId(), this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String url = node.getHttpUrl() + "/" + StoreSwapper.this.readOnlyMgmtPath;
                    PostMethod post = new PostMethod(url);
                    post.addParameter("operation", "fetch");
                    String storeDir = basePath + "/node-" + node.getId();
                    post.addParameter("dir", storeDir);
                    post.addParameter("store", storeName);
                    logger.info("Invoking fetch for node " + node.getId() + " for " + storeDir);
                    int responseCode = StoreSwapper.this.httpClient.executeMethod((HttpMethod)post);
                    String response = post.getResponseBodyAsString(30000);
                    if (responseCode != 200) {
                        throw new VoldemortException("Swap request on node " + node.getId() + " (" + url + ") failed: " + post.getStatusText());
                    }
                    logger.info("Fetch succeeded on node " + node.getId());
                    return response.trim();
                }
            }));
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int nodeId = 0; nodeId < this.cluster.getNumberOfNodes(); ++nodeId) {
            Future val = (Future)fetchDirs.get(nodeId);
            try {
                results.add((String)val.get());
                continue;
            }
            catch (ExecutionException e) {
                throw new VoldemortException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new VoldemortException(e);
            }
        }
        return results;
    }

    private void invokeSwap(String storeName, List<String> fetchFiles) {
        int successes = 0;
        Exception exception = null;
        for (int nodeId = 0; nodeId < this.cluster.getNumberOfNodes(); ++nodeId) {
            try {
                Node node = this.cluster.getNodeById(nodeId);
                String url = node.getHttpUrl() + "/" + this.readOnlyMgmtPath;
                PostMethod post = new PostMethod(url);
                post.addParameter("operation", "swap");
                String dir = fetchFiles.get(nodeId);
                logger.info("Attempting swap for node " + nodeId + " dir = " + dir);
                post.addParameter("dir", dir);
                post.addParameter("store", storeName);
                int responseCode = this.httpClient.executeMethod((HttpMethod)post);
                String response = post.getStatusText();
                if (responseCode == 200) {
                    ++successes;
                } else {
                    throw new VoldemortException(response);
                }
                logger.info("Swap succeeded for node " + node.getId());
                continue;
            }
            catch (Exception e) {
                exception = e;
                logger.error("Exception thrown during swap operation on node " + nodeId + ": ", e);
            }
        }
        if (exception != null) {
            throw new VoldemortException(exception);
        }
    }

    public static void main(String[] args) throws Exception {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print usage information");
        parser.accepts("cluster", "[REQUIRED] the voldemort cluster.xml file ").withRequiredArg().describedAs("cluster.xml");
        parser.accepts("name", "[REQUIRED] the name of the store to swap").withRequiredArg().describedAs("store-name");
        parser.accepts("servlet-path", "the path for the read-only management servlet").withRequiredArg().describedAs("path");
        parser.accepts("file", "[REQUIRED] uri of a directory containing the new store files").withRequiredArg().describedAs("uri");
        parser.accepts("timeout", "http timeout for the fetch in ms").withRequiredArg().describedAs("timeout ms").ofType(Integer.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing(options, "cluster", "name", "file")).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on(", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String clusterXml = (String)options.valueOf("cluster");
        String storeName = (String)options.valueOf("name");
        String mgmtPath = CmdUtils.valueOf(options, "servlet-path", "read-only/mgmt");
        String filePath = (String)options.valueOf("file");
        int timeoutMs = CmdUtils.valueOf(options, "timeout", Integer.valueOf(10800000));
        String clusterStr = FileUtils.readFileToString((File)new File(clusterXml));
        Cluster cluster = new ClusterMapper().readCluster(new StringReader(clusterStr));
        ExecutorService executor = Executors.newFixedThreadPool(10);
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        int numConnections = cluster.getNumberOfNodes() + 3;
        manager.getParams().setMaxTotalConnections(numConnections);
        manager.getParams().setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, numConnections);
        HttpClient client = new HttpClient((HttpConnectionManager)manager);
        client.getParams().setParameter("http.socket.timeout", (Object)timeoutMs);
        StoreSwapper swapper = new StoreSwapper(cluster, executor, client, mgmtPath);
        long start = System.currentTimeMillis();
        swapper.swapStoreData(storeName, filePath);
        long end = System.currentTimeMillis();
        logger.info("Swap succeeded on all nodes in " + (end - start) / 1000L + " seconds.");
        executor.shutdownNow();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        System.exit(0);
    }
}

