/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.readonly.ChunkedFileSet;
import voldemort.store.readonly.SearchStrategy;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStorageEngine
implements StorageEngine<ByteArray, byte[]> {
    private static Logger logger = Logger.getLogger(ReadOnlyStorageEngine.class);
    public static final int MEMORY_OVERHEAD_PER_KEY = 40;
    private final String name;
    private final int numBackups;
    private final File storeDir;
    private final ReadWriteLock fileModificationLock;
    private final SearchStrategy searchStrategy;
    private volatile ChunkedFileSet fileSet;
    private volatile boolean isOpen;

    public ReadOnlyStorageEngine(String name, SearchStrategy searchStrategy, File storeDir, int numBackups) {
        this.storeDir = storeDir;
        this.numBackups = numBackups;
        this.name = Utils.notNull(name);
        this.searchStrategy = searchStrategy;
        this.fileSet = null;
        this.fileModificationLock = new ReentrantReadWriteLock();
        this.isOpen = false;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        this.fileModificationLock.writeLock().lock();
        try {
            if (this.isOpen) {
                throw new IllegalStateException("Attempt to open already open store.");
            }
            File version0 = new File(this.storeDir, "version-0");
            version0.mkdirs();
            this.fileSet = new ChunkedFileSet(version0);
            this.isOpen = true;
        }
        finally {
            this.fileModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws VoldemortException {
        logger.debug("Close called for read-only store.");
        this.fileModificationLock.writeLock().lock();
        try {
            if (this.isOpen) {
                this.isOpen = false;
                this.fileSet.close();
            } else {
                logger.debug("Attempt to close already closed store " + this.getName());
            }
        }
        finally {
            this.fileModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="swapFiles(newIndexFile, newDataFile) changes this store  to use the given index and data file.")
    public void swapFiles(String newStoreDirectory) {
        logger.info("Swapping files for store '" + this.getName() + "' from " + newStoreDirectory);
        File newDataDir = new File(newStoreDirectory);
        if (!newDataDir.exists()) {
            throw new VoldemortException("File " + newDataDir.getAbsolutePath() + " does not exist.");
        }
        logger.info("Acquiring write lock on '" + this.getName() + "':");
        this.fileModificationLock.writeLock().lock();
        boolean success = false;
        try {
            this.close();
            logger.info("Renaming data and index files for '" + this.getName() + "':");
            this.shiftBackupsRight();
            logger.info("Setting primary files for store '" + this.getName() + "' to " + newStoreDirectory);
            File destDir = new File(this.storeDir, "version-0");
            if (!newDataDir.renameTo(destDir)) {
                throw new VoldemortException("Renaming " + newDataDir.getAbsolutePath() + " to " + destDir.getAbsolutePath() + " failed!");
            }
            this.open();
            success = true;
        }
        finally {
            try {
                if (!success) {
                    this.rollback();
                }
            }
            finally {
                this.fileModificationLock.writeLock().unlock();
                if (success) {
                    logger.info("Swap operation completed successfully on store " + this.getName() + ", releasing lock.");
                } else {
                    logger.error("Swap operation failed.");
                }
            }
        }
        File extraBackup = new File(this.storeDir, "version-" + (this.numBackups + 1));
        if (extraBackup.exists()) {
            this.deleteAsync(extraBackup);
        }
    }

    public void deleteAsync(final File file) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    logger.info("Deleting file " + file);
                    Utils.rm(file);
                    logger.info("Delete completed successfully.");
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
        }, "background-file-delete").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="Rollback to the most recent backup of the current store.")
    public void rollback() {
        logger.info("Rolling back store '" + this.getName() + "' to version 1.");
        this.fileModificationLock.writeLock().lock();
        try {
            File backup;
            if (this.isOpen) {
                this.close();
            }
            if (!(backup = new File(this.storeDir, "version-1")).exists()) {
                throw new VoldemortException("Version 1 does not exists, nothing to roll back to.");
            }
            this.shiftBackupsLeft();
            this.open();
        }
        finally {
            this.fileModificationLock.writeLock().unlock();
            logger.info("Rollback operation completed on '" + this.getName() + "', releasing lock.");
        }
    }

    private void shiftBackupsLeft() {
        if (this.isOpen) {
            throw new VoldemortException("Can't move backup files while store is open.");
        }
        File primary = new File(this.storeDir, "version-0");
        SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
        if (primary.exists()) {
            Utils.move(primary, new File(this.storeDir, "version-0." + df.format(new Date()) + ".bak"));
        }
        this.shiftBackupsLeft(0);
    }

    private void shiftBackupsLeft(int beginShift) {
        File source = new File(this.storeDir, "version-" + Integer.toString(beginShift + 1));
        File dest = new File(this.storeDir, "version-" + Integer.toString(beginShift));
        if (!source.exists()) {
            return;
        }
        source.renameTo(dest);
        this.shiftBackupsLeft(beginShift + 1);
    }

    private void shiftBackupsRight() {
        if (this.isOpen) {
            throw new VoldemortException("Can't move backup files while store is open.");
        }
        this.shiftBackupsRight(0);
    }

    private void shiftBackupsRight(int beginShift) {
        if (this.isOpen) {
            throw new VoldemortException("Can't move backup files while store is open.");
        }
        File source = new File(this.storeDir, "version-" + Integer.toString(beginShift));
        if (!source.exists()) {
            return;
        }
        File dest = new File(this.storeDir, "version-" + Integer.toString(beginShift + 1));
        if (dest.exists()) {
            this.shiftBackupsRight(beginShift + 1);
        }
        source.renameTo(dest);
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        throw new UnsupportedOperationException("Iteration is not supported for " + this.getClass().getName());
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        throw new UnsupportedOperationException("Iteration is not supported for " + this.getClass().getName());
    }

    @Override
    public void truncate() {
        throw new UnsupportedOperationException("Truncation is not supported for " + this.getClass().getName());
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        byte[] keyMd5 = ByteUtils.md5(key.get());
        int chunk = this.fileSet.getChunkForKey(keyMd5);
        int location = this.searchStrategy.indexOf(this.fileSet.indexFileFor(chunk), keyMd5, this.fileSet.getIndexFileSize(chunk));
        if (location >= 0) {
            byte[] value = this.readValue(chunk, location);
            return Collections.singletonList(Versioned.value(value));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        HashMap<ByteArray, List<Versioned<byte[]>>> results = StoreUtils.newEmptyHashMap(keys);
        try {
            this.fileModificationLock.readLock().lock();
            ArrayList<KeyValueLocation> keysAndValueLocations = Lists.newArrayList();
            for (ByteArray key : keys) {
                byte[] keyMd5 = ByteUtils.md5(key.get());
                int chunk = this.fileSet.getChunkForKey(keyMd5);
                int valueLocation = this.searchStrategy.indexOf(this.fileSet.indexFileFor(chunk), keyMd5, this.fileSet.getIndexFileSize(chunk));
                if (valueLocation < 0) continue;
                keysAndValueLocations.add(new KeyValueLocation(chunk, key, valueLocation));
            }
            Collections.sort(keysAndValueLocations);
            for (KeyValueLocation keyVal : keysAndValueLocations) {
                byte[] value = this.readValue(keyVal.getChunk(), keyVal.getValueLocation());
                results.put(keyVal.getKey(), Collections.singletonList(Versioned.value(value)));
            }
            HashMap<ByteArray, List<Versioned<byte[]>>> hashMap = results;
            return hashMap;
        }
        finally {
            this.fileModificationLock.readLock().unlock();
        }
    }

    private byte[] readValue(int chunk, int valueLocation) {
        FileChannel dataFile = this.fileSet.dataFileFor(chunk);
        try {
            ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
            dataFile.read(sizeBuffer, valueLocation);
            int size = sizeBuffer.getInt(0);
            ByteBuffer valueBuffer = ByteBuffer.allocate(size);
            dataFile.read(valueBuffer, valueLocation + 4);
            return valueBuffer.array();
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        throw new UnsupportedOperationException("Delete is not supported on this store, it is read-only.");
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        throw new UnsupportedOperationException("Put is not supported on this store, it is read-only.");
    }

    @Override
    @JmxGetter(name="name", description="The name of the store.")
    public String getName() {
        return this.name;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return StoreUtils.getVersions(this.get(key));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyValueLocation
    implements Comparable<KeyValueLocation> {
        private final int chunk;
        private final ByteArray key;
        private final int valueLocation;

        private KeyValueLocation(int chunk, ByteArray key, int valueLocation) {
            this.chunk = chunk;
            this.key = key;
            this.valueLocation = valueLocation;
        }

        public int getChunk() {
            return this.chunk;
        }

        public ByteArray getKey() {
            return this.key;
        }

        public int getValueLocation() {
            return this.valueLocation;
        }

        @Override
        public int compareTo(KeyValueLocation kvl) {
            if (this.chunk == kvl.getChunk()) {
                if (this.valueLocation == kvl.getValueLocation()) {
                    return ByteUtils.compare(this.getKey().get(), kvl.getKey().get());
                }
                return Integer.signum(this.valueLocation - kvl.getValueLocation());
            }
            return this.getChunk() - kvl.getChunk();
        }
    }
}

