/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.readonly.SearchStrategy;
import voldemort.utils.ByteArray;
import voldemort.utils.JmxUtils;
import voldemort.utils.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStorageConfiguration
implements StorageConfiguration {
    public static final String TYPE_NAME = "read-only";
    private final int numBackups;
    private final File storageDir;
    private final Set<ObjectName> registeredBeans;
    private final SearchStrategy searcher;
    private final int nodeId;

    public ReadOnlyStorageConfiguration(VoldemortConfig config) {
        this.storageDir = new File(config.getReadOnlyDataStorageDirectory());
        this.numBackups = config.getReadOnlyBackups();
        this.registeredBeans = Collections.synchronizedSet(new HashSet());
        this.searcher = (SearchStrategy)ReflectUtils.callConstructor(ReflectUtils.loadClass(config.getReadOnlySearchStrategy().trim()));
        this.nodeId = config.getNodeId();
    }

    @Override
    public void close() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName name : this.registeredBeans) {
            JmxUtils.unregisterMbean(server, name);
        }
    }

    @Override
    public StorageEngine<ByteArray, byte[]> getStore(String name) {
        ReadOnlyStorageEngine store = new ReadOnlyStorageEngine(name, this.searcher, new File(this.storageDir, name), this.numBackups);
        ObjectName objName = JmxUtils.createObjectName(JmxUtils.getPackageName(store.getClass()), name + this.nodeId);
        JmxUtils.registerMbean(ManagementFactory.getPlatformMBeanServer(), JmxUtils.createModelMBean(store), objName);
        this.registeredBeans.add(objName);
        return store;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }
}

