/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import java.nio.ByteBuffer;
import voldemort.store.readonly.SearchStrategy;
import voldemort.utils.ByteUtils;

public class InterpolationSearchStrategy
implements SearchStrategy {
    private final byte[] MIN_KEY = new byte[16];
    private final byte[] MAX_KEY = new byte[16];

    public InterpolationSearchStrategy() {
        for (int i = 0; i < 16; ++i) {
            this.MIN_KEY[i] = 0;
            this.MAX_KEY[i] = -1;
        }
    }

    public int indexOf(ByteBuffer index, byte[] key, int indexSize) {
        int lowIdx = 0;
        int highIdx = indexSize / 20 - 1;
        long lastIdx = highIdx;
        long lowValue = 0L;
        long highValue = 0xFFFFFFFFL;
        long keyInt = ByteUtils.readUnsignedInt(key, 0);
        byte[] found = new byte[16];
        while (lowIdx <= highIdx && keyInt >= lowValue && keyInt <= highValue) {
            int guess;
            if (highIdx == lowIdx) {
                guess = highIdx;
            } else {
                long size = highIdx - lowIdx;
                long offset = (size - 1L) * (keyInt - lowValue) / (highValue - lowValue);
                guess = lowIdx + (int)offset;
            }
            index.position(guess * 20);
            index.get(found);
            int compare = ByteUtils.compare(key, found);
            if (compare == 0) {
                return index.getInt();
            }
            long foundInt = ByteUtils.readUnsignedInt(found, 0);
            if (compare == -1) {
                if (guess == 0) {
                    return -1;
                }
                highIdx = guess - 1;
                highValue = foundInt;
                continue;
            }
            if ((long)guess == lastIdx) {
                return -1;
            }
            lowIdx = guess + 1;
            lowValue = foundInt;
        }
        return -1;
    }
}

