/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import java.nio.ByteBuffer;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.SearchStrategy;
import voldemort.utils.ByteUtils;

public class BinarySearchStrategy
implements SearchStrategy {
    public int indexOf(ByteBuffer index, byte[] key, int indexFileSize) {
        byte[] keyBuffer = new byte[16];
        int low = 0;
        int high = indexFileSize / 20 - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            ReadOnlyUtils.readKey(index, mid * 20, keyBuffer);
            int cmp = ByteUtils.compare(keyBuffer, key);
            if (cmp == 0) {
                index.position(mid * 20 + 16);
                return index.getInt();
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (cmp >= 0) continue;
            low = mid + 1;
        }
        return -1;
    }
}

