/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.mysql;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.PersistenceFailureException;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlStorageEngine
implements StorageEngine<ByteArray, byte[]> {
    private static final Logger logger = Logger.getLogger(MysqlStorageEngine.class);
    private static int MYSQL_ERR_DUP_KEY = 1022;
    private static int MYSQL_ERR_DUP_ENTRY = 1062;
    private final String name;
    private final DataSource datasource;

    public MysqlStorageEngine(String name, DataSource datasource) {
        this.name = name;
        this.datasource = datasource;
        if (!this.tableExists()) {
            this.create();
        }
    }

    private boolean tableExists() {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String select = "show tables like '" + this.getName() + "'";
        try {
            conn = this.datasource.getConnection();
            stmt = conn.prepareStatement(select);
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            this.tryClose(rs);
            this.tryClose(stmt);
            this.tryClose(conn);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceFailureException("SQLException while checking for table existence!", e);
            }
            catch (Throwable throwable) {
                this.tryClose(rs);
                this.tryClose(stmt);
                this.tryClose(conn);
                throw throwable;
            }
        }
    }

    public void destroy() {
        this.execute("drop table if exists " + this.getName());
    }

    public void create() {
        this.execute("create table " + this.getName() + " (key_ varbinary(200) not null, version_ varbinary(200) not null, " + " value_ blob, primary key(key_, version_)) engine = InnoDB");
    }

    public void execute(String query) {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.datasource.getConnection();
            stmt = conn.prepareStatement(query);
            stmt.executeUpdate();
            this.tryClose(stmt);
            this.tryClose(conn);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceFailureException("SQLException while performing operation.", e);
            }
            catch (Throwable throwable) {
                this.tryClose(stmt);
                this.tryClose(conn);
                throw throwable;
            }
        }
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        return StoreUtils.keys(this.entries());
    }

    @Override
    public void truncate() {
        Connection conn = null;
        PreparedStatement stmt = null;
        String select = "delete from " + this.name;
        try {
            conn = this.datasource.getConnection();
            stmt = conn.prepareStatement(select);
            stmt.executeUpdate();
            this.tryClose(stmt);
            this.tryClose(conn);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceFailureException("Fix me!", e);
            }
            catch (Throwable throwable) {
                this.tryClose(stmt);
                this.tryClose(conn);
                throw throwable;
            }
        }
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String select = "select key_, version_, value_ from " + this.name;
        try {
            conn = this.datasource.getConnection();
            stmt = conn.prepareStatement(select);
            rs = stmt.executeQuery();
            return new MysqlClosableIterator(conn, stmt, rs);
        }
        catch (SQLException e) {
            throw new PersistenceFailureException("Fix me!", e);
        }
    }

    @Override
    public void close() throws PersistenceFailureException {
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public boolean delete(ByteArray key, Version maxVersion) throws PersistenceFailureException {
        StoreUtils.assertValidKey(key);
        Connection conn = null;
        PreparedStatement selectStmt = null;
        ResultSet rs = null;
        String select = "select key_, version_ from " + this.name + " where key_ = ? for update";
        try {
            conn = this.datasource.getConnection();
            selectStmt = conn.prepareStatement(select);
            selectStmt.setBytes(1, key.get());
            rs = selectStmt.executeQuery();
            boolean deletedSomething = false;
            while (rs.next()) {
                byte[] theKey = rs.getBytes("key_");
                byte[] version = rs.getBytes("version_");
                if (new VectorClock(version).compare(maxVersion) != Occured.BEFORE) continue;
                this.delete(conn, theKey, version);
                deletedSomething = true;
            }
            boolean bl = deletedSomething;
            this.tryClose(rs);
            this.tryClose(selectStmt);
            this.tryClose(conn);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceFailureException("Fix me!", e);
            }
            catch (Throwable throwable) {
                this.tryClose(rs);
                this.tryClose(selectStmt);
                this.tryClose(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(Connection connection, byte[] key, byte[] version) throws SQLException {
        String delete = "delete from " + this.name + " where key_ = ? and version_ = ?";
        PreparedStatement deleteStmt = null;
        try {
            deleteStmt = connection.prepareStatement(delete);
            deleteStmt.setBytes(1, key);
            deleteStmt.setBytes(2, version);
            deleteStmt.executeUpdate();
        }
        finally {
            this.tryClose(deleteStmt);
        }
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String select = "select version_, value_ from " + this.name + " where key_ = ?";
        try {
            conn = this.datasource.getConnection();
            stmt = conn.prepareStatement(select);
            HashMap<ByteArray, List<Versioned<byte[]>>> result = StoreUtils.newEmptyHashMap(keys);
            for (ByteArray key : keys) {
                stmt.setBytes(1, key.get());
                rs = stmt.executeQuery();
                ArrayList<Versioned<byte[]>> found = Lists.newArrayList();
                while (rs.next()) {
                    byte[] version = rs.getBytes("version_");
                    byte[] value = rs.getBytes("value_");
                    found.add(new Versioned<byte[]>(value, new VectorClock(version)));
                }
                if (found.size() <= 0) continue;
                result.put(key, found);
            }
            HashMap<ByteArray, List<Versioned<byte[]>>> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw new PersistenceFailureException("Fix me!", e);
        }
        finally {
            this.tryClose(rs);
            this.tryClose(stmt);
            this.tryClose(conn);
        }
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) throws PersistenceFailureException {
        StoreUtils.assertValidKey(key);
        return StoreUtils.get(this, key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(ByteArray key, Versioned<byte[]> value) throws PersistenceFailureException {
        ResultSet results;
        PreparedStatement select;
        PreparedStatement insert;
        Connection conn;
        block15: {
            StoreUtils.assertValidKey(key);
            boolean doCommit = false;
            conn = null;
            insert = null;
            select = null;
            results = null;
            String insertSql = "insert into " + this.name + " (key_, version_, value_) values (?, ?, ?)";
            String selectSql = "select key_, version_ from " + this.name + " where key_ = ?";
            try {
                conn = this.datasource.getConnection();
                conn.setAutoCommit(false);
                select = conn.prepareStatement(selectSql);
                select.setBytes(1, key.get());
                results = select.executeQuery();
                while (results.next()) {
                    byte[] thisKey = results.getBytes("key_");
                    VectorClock version = new VectorClock(results.getBytes("version_"));
                    Occured occured = value.getVersion().compare(version);
                    if (occured == Occured.BEFORE) {
                        throw new ObsoleteVersionException("Attempt to put version " + value.getVersion() + " which is superceeded by " + version + ".");
                    }
                    if (occured != Occured.AFTER) continue;
                    this.delete(conn, thisKey, version.toBytes());
                }
                insert = conn.prepareStatement(insertSql);
                insert.setBytes(1, key.get());
                VectorClock clock = (VectorClock)value.getVersion();
                insert.setBytes(2, clock.toBytes());
                insert.setBytes(3, value.getValue());
                insert.executeUpdate();
                doCommit = true;
                if (conn == null) break block15;
            }
            catch (SQLException e) {
                try {
                    if (e.getErrorCode() == MYSQL_ERR_DUP_KEY) throw new ObsoleteVersionException("Key or value already used.");
                    if (e.getErrorCode() != MYSQL_ERR_DUP_ENTRY) throw new PersistenceFailureException("Fix me!", e);
                    throw new ObsoleteVersionException("Key or value already used.");
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            if (doCommit) {
                                conn.commit();
                            } else {
                                conn.rollback();
                            }
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    this.tryClose(results);
                    this.tryClose(insert);
                    this.tryClose(select);
                    this.tryClose(conn);
                    throw throwable;
                }
            }
            try {
                if (doCommit) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.tryClose(results);
        this.tryClose(insert);
        this.tryClose(select);
        this.tryClose(conn);
    }

    private void tryClose(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed to close resultset.", e);
        }
    }

    private void tryClose(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed to close connection.", e);
        }
    }

    private void tryClose(PreparedStatement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            logger.error("Failed to close prepared statement.", e);
        }
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return StoreUtils.getVersions(this.get(key));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MysqlClosableIterator
    implements ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> {
        private boolean hasMore;
        private final ResultSet rs;
        private final Connection connection;
        private final PreparedStatement statement;

        public MysqlClosableIterator(Connection connection, PreparedStatement statement, ResultSet resultSet) {
            try {
                this.hasMore = resultSet.next();
            }
            catch (SQLException e) {
                throw new PersistenceFailureException(e);
            }
            this.rs = resultSet;
            this.connection = connection;
            this.statement = statement;
        }

        @Override
        public void close() {
            MysqlStorageEngine.this.tryClose(this.rs);
            MysqlStorageEngine.this.tryClose(this.statement);
            MysqlStorageEngine.this.tryClose(this.connection);
        }

        @Override
        public boolean hasNext() {
            return this.hasMore;
        }

        @Override
        public Pair<ByteArray, Versioned<byte[]>> next() {
            try {
                if (!this.hasMore) {
                    throw new PersistenceFailureException("Next called on iterator, but no more items available!");
                }
                ByteArray key = new ByteArray(this.rs.getBytes("key_"));
                byte[] value = this.rs.getBytes("value_");
                VectorClock clock = new VectorClock(this.rs.getBytes("version_"));
                this.hasMore = this.rs.next();
                return Pair.create(key, new Versioned<byte[]>(value, clock));
            }
            catch (SQLException e) {
                throw new PersistenceFailureException(e);
            }
        }

        @Override
        public void remove() {
            try {
                this.rs.deleteRow();
            }
            catch (SQLException e) {
                throw new PersistenceFailureException(e);
            }
        }
    }
}

