/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.mysql;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import voldemort.VoldemortException;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.mysql.MysqlStorageEngine;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlStorageConfiguration
implements StorageConfiguration {
    public static final String TYPE_NAME = "mysql";
    private BasicDataSource dataSource;

    public MysqlStorageConfiguration(VoldemortConfig config) {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl("jdbc:mysql://" + config.getMysqlHost() + ":" + config.getMysqlPort() + "/" + config.getMysqlDatabaseName());
        ds.setUsername(config.getMysqlUsername());
        ds.setPassword(config.getMysqlPassword());
        ds.setDriverClassName("com.mysql.jdbc.Driver");
        this.dataSource = ds;
    }

    @Override
    public StorageEngine<ByteArray, byte[]> getStore(String name) {
        return new MysqlStorageEngine(name, (DataSource)this.dataSource);
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public void close() {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            throw new VoldemortException("Exception while closing connection pool.", e);
        }
    }
}

