/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.logging;

import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingStore<K, V>
extends DelegatingStore<K, V> {
    private final Logger logger;
    private final Time time;
    private final String instanceName;

    public LoggingStore(Store<K, V> store) {
        this(store, new SystemTime());
    }

    public LoggingStore(Store<K, V> store, Time time) {
        this(store, null, time);
    }

    public LoggingStore(Store<K, V> store, String instance, Time time) {
        super(store);
        this.logger = Logger.getLogger(store.getClass());
        this.time = time;
        this.instanceName = instance == null ? ": " : instance + ": ";
    }

    @Override
    public void close() throws VoldemortException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Closing " + this.getName() + ".");
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(K key, Version version) throws VoldemortException {
        long startTimeNs = 0L;
        boolean succeeded = false;
        if (this.logger.isDebugEnabled()) {
            startTimeNs = this.time.getNanoseconds();
        }
        try {
            boolean deletedSomething = this.getInnerStore().delete(key, version);
            succeeded = true;
            boolean bl = deletedSomething;
            return bl;
        }
        finally {
            this.printTimedMessage("DELETE", succeeded, startTimeNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Versioned<V>> get(K key) throws VoldemortException {
        long startTimeNs = 0L;
        boolean succeeded = false;
        if (this.logger.isDebugEnabled()) {
            startTimeNs = this.time.getNanoseconds();
        }
        try {
            List l = this.getInnerStore().get(key);
            succeeded = true;
            List list = l;
            return list;
        }
        finally {
            this.printTimedMessage("GET", succeeded, startTimeNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, Versioned<V> value) throws VoldemortException {
        long startTimeNs = 0L;
        boolean succeeded = false;
        if (this.logger.isDebugEnabled()) {
            startTimeNs = this.time.getNanoseconds();
        }
        try {
            this.getInnerStore().put(key, value);
            succeeded = true;
        }
        finally {
            this.printTimedMessage("PUT", succeeded, startTimeNs);
        }
    }

    private void printTimedMessage(String operation, boolean success, long startNs) {
        if (this.logger.isDebugEnabled()) {
            double elapsedMs = (double)(this.time.getNanoseconds() - startNs) / 1000000.0;
            this.logger.debug(this.instanceName + operation + " operation on store '" + this.getName() + "' completed " + (success ? "successfully" : "unsuccessfully") + " in " + elapsedMs + " ms.");
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (capability == StoreCapabilityType.LOGGER) {
            return this.logger;
        }
        return this.getInnerStore().getCapability(capability);
    }
}

