/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.invalidmetadata;

import java.util.List;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreUtils;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidMetadataCheckingStore
extends DelegatingStore<ByteArray, byte[]> {
    private final int nodeId;
    private final MetadataStore metadata;

    public InvalidMetadataCheckingStore(int nodeId, Store<ByteArray, byte[]> innerStore, MetadataStore metadata) {
        super(innerStore);
        this.metadata = metadata;
        this.nodeId = nodeId;
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        StoreUtils.assertValidMetadata(key, this.metadata.getRoutingStrategy(this.getName()), this.metadata.getCluster().getNodeById(this.nodeId));
        return this.getInnerStore().delete(key, version);
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        StoreUtils.assertValidMetadata(key, this.metadata.getRoutingStrategy(this.getName()), this.metadata.getCluster().getNodeById(this.nodeId));
        this.getInnerStore().put(key, value);
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        StoreUtils.assertValidMetadata(key, this.metadata.getRoutingStrategy(this.getName()), this.metadata.getCluster().getNodeById(this.nodeId));
        return this.getInnerStore().get(key);
    }
}

