/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.http;

import voldemort.VoldemortException;
import voldemort.store.UnknownFailure;
import voldemort.versioning.ObsoleteVersionException;

public class HttpResponseCodeErrorMapper {
    public VoldemortException mapResponseCodeToError(int responseCode, String message) {
        if (responseCode >= 200 && responseCode < 300) {
            return null;
        }
        if (responseCode == 409) {
            throw new ObsoleteVersionException(message);
        }
        throw new UnknownFailure("Unknown failure occured in HTTP operation: " + responseCode + " - " + message);
    }

    public ResponseCode mapErrorToResponseCode(VoldemortException v) {
        if (v instanceof ObsoleteVersionException) {
            return new ResponseCode(409, v.getMessage());
        }
        return new ResponseCode(502, v.getMessage());
    }

    public void throwError(int responseCode, String message) {
        if (responseCode >= 200 && responseCode < 300) {
            return;
        }
        throw this.mapResponseCodeToError(responseCode, message);
    }

    public static final class ResponseCode {
        private final int responseCode;
        private final String responseText;

        public ResponseCode(int responseCode, String responseText) {
            this.responseCode = responseCode;
            this.responseText = responseText;
        }

        public int getCode() {
            return this.responseCode;
        }

        public String getText() {
            return this.responseText;
        }
    }
}

