/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationStorageEngine
implements StorageEngine<String, String> {
    private static final Logger logger = Logger.getLogger(ConfigurationStorageEngine.class);
    private final String name;
    private final File directory;

    public ConfigurationStorageEngine(String name, String directory) {
        this.name = name;
        this.directory = new File(directory);
        if (!this.directory.exists() && this.directory.canRead()) {
            throw new IllegalArgumentException("Directory " + this.directory.getAbsolutePath() + " does not exist or can not be read.");
        }
    }

    @Override
    public ClosableIterator<Pair<String, Versioned<String>>> entries() {
        throw new VoldemortException("Iteration  not supported in ConfigurationStorageEngine");
    }

    @Override
    public void close() throws VoldemortException {
    }

    @Override
    public synchronized boolean delete(String key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        for (File file : this.getDirectory(key).listFiles()) {
            if (!file.getName().equals(key)) continue;
            try {
                return file.delete() && new File(this.getVersionDirectory(), file.getName()).delete();
            }
            catch (Exception e) {
                logger.error("Error while attempt to delete key:" + key, e);
            }
        }
        return false;
    }

    @Override
    public synchronized List<Versioned<String>> get(String key) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.get(key, this.getDirectory(key).listFiles());
    }

    @Override
    public List<Version> getVersions(String key) {
        List<Versioned<String>> values = this.get(key);
        ArrayList<Version> versions = new ArrayList<Version>(values.size());
        for (Versioned<String> value : values) {
            versions.add(value.getVersion());
        }
        return versions;
    }

    @Override
    public synchronized Map<String, List<Versioned<String>>> getAll(Iterable<String> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        HashMap<String, List<Versioned<String>>> result = StoreUtils.newEmptyHashMap(keys);
        for (String key : keys) {
            List<Versioned<String>> values = this.get(key, this.getDirectory(key).listFiles());
            if (values.isEmpty()) continue;
            result.put(key, values);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void put(String key, Versioned<String> value) throws VoldemortException {
        File[] files;
        StoreUtils.assertValidKey(key);
        if (null == value.getValue()) {
            throw new VoldemortException("metadata cannot be null !!");
        }
        for (File file : files = this.getDirectory(key).listFiles()) {
            if (!file.getName().equals(key)) continue;
            VectorClock clock = this.readVersion(key);
            if (value.getVersion().compare(clock) == Occured.AFTER) continue;
            if (value.getVersion().compare(clock) == Occured.BEFORE) {
                throw new ObsoleteVersionException("A successor version " + clock + "  to this " + value.getVersion() + " exists for key " + key);
            }
            if (value.getVersion().compare(clock) != Occured.CONCURRENTLY) continue;
            throw new ObsoleteVersionException("Concurrent Operation not allowed on Metadata.");
        }
        File keyFile = new File(this.getDirectory(key), key);
        VectorClock newClock = (VectorClock)value.getVersion();
        if (!keyFile.exists() || keyFile.delete()) {
            try {
                FileUtils.writeStringToFile((File)keyFile, (String)value.getValue(), (String)"UTF-8");
                this.writeVersion(key, newClock);
            }
            catch (IOException e) {
                throw new VoldemortException(e);
            }
        }
    }

    private File getDirectory(String key) {
        if (MetadataStore.OPTIONAL_KEYS.contains(key)) {
            return this.getTempDirectory();
        }
        return this.directory;
    }

    private List<Versioned<String>> get(String key, File[] files) {
        try {
            ArrayList<Versioned<String>> found = new ArrayList<Versioned<String>>();
            for (File file : files) {
                VectorClock clock;
                if (!file.getName().equals(key) || null == (clock = this.readVersion(key))) continue;
                found.add(new Versioned<String>(FileUtils.readFileToString((File)file, (String)"UTF-8"), clock));
            }
            return found;
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    private VectorClock readVersion(String key) {
        try {
            File versionFile = new File(this.getVersionDirectory(), key);
            if (!versionFile.exists()) {
                VectorClock clock = new VectorClock();
                this.writeVersion(key, clock);
                return clock;
            }
            String hexCode = FileUtils.readFileToString((File)versionFile, (String)"UTF-8");
            return new VectorClock(Hex.decodeHex((char[])hexCode.toCharArray()));
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to read Version for Key:" + key, e);
        }
    }

    private void writeVersion(String key, VectorClock version) {
        try {
            File versionFile = new File(this.getVersionDirectory(), key);
            if (!versionFile.exists() || versionFile.delete()) {
                String hexCode = new String(Hex.encodeHex((byte[])version.toBytes()));
                FileUtils.writeStringToFile((File)versionFile, (String)hexCode, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to write Version for Key:" + key, e);
        }
    }

    private File getVersionDirectory() {
        File versionDir = new File(this.directory, ".version");
        if (!versionDir.exists() || !versionDir.isDirectory()) {
            versionDir.delete();
            versionDir.mkdirs();
        }
        return versionDir;
    }

    private File getTempDirectory() {
        File tempDir = new File(this.directory, ".temp");
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            tempDir.delete();
            tempDir.mkdirs();
        }
        return tempDir;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new VoldemortException("No extra capability.");
    }

    @Override
    public ClosableIterator<String> keys() {
        throw new VoldemortException("keys iteration not supported.");
    }

    @Override
    public void truncate() {
        throw new VoldemortException("Truncate not supported in ConfigurationStorageEngine");
    }
}

