/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb;

import com.google.common.collect.Maps;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.StatsConfig;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.StorageInitializationException;
import voldemort.store.bdb.BdbStorageEngine;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbStorageConfiguration
implements StorageConfiguration {
    public static final String TYPE_NAME = "bdb";
    private static final String SHARED_ENV_KEY = "shared";
    private static Logger logger = Logger.getLogger(BdbStorageConfiguration.class);
    private final Object lock = new Object();
    private final Map<String, Environment> environments = Maps.newHashMap();
    private final EnvironmentConfig environmentConfig;
    private final DatabaseConfig databaseConfig;
    private final Map<String, BdbStorageEngine> stores = Maps.newHashMap();
    private final String bdbMasterDir;
    private final boolean useOneEnvPerStore;
    private final VoldemortConfig voldemortConfig;

    public BdbStorageConfiguration(VoldemortConfig config) {
        this.voldemortConfig = config;
        this.environmentConfig = new EnvironmentConfig();
        this.environmentConfig.setTransactional(true);
        this.environmentConfig.setCacheSize(config.getBdbCacheSize());
        if (config.isBdbWriteTransactionsEnabled() && config.isBdbFlushTransactionsEnabled()) {
            this.environmentConfig.setTxnNoSync(false);
            this.environmentConfig.setTxnWriteNoSync(false);
        } else if (config.isBdbWriteTransactionsEnabled() && !config.isBdbFlushTransactionsEnabled()) {
            this.environmentConfig.setTxnNoSync(false);
            this.environmentConfig.setTxnWriteNoSync(true);
        } else {
            this.environmentConfig.setTxnNoSync(true);
        }
        this.environmentConfig.setAllowCreate(true);
        this.environmentConfig.setConfigParam("je.log.fileMax", Long.toString(config.getBdbMaxLogFileSize()));
        this.environmentConfig.setConfigParam("je.checkpointer.bytesInterval", Long.toString(config.getBdbCheckpointBytes()));
        this.environmentConfig.setConfigParam("je.checkpointer.wakeupInterval", Long.toString(config.getBdbCheckpointMs() * 1000L));
        this.environmentConfig.setConfigParam("je.cleaner.minFileUtilization", Integer.toString(config.getBdbCleanerMinFileUtilization()));
        this.environmentConfig.setConfigParam("je.cleaner.minUtilization", Integer.toString(config.getBdbCleanerMinUtilization()));
        this.databaseConfig = new DatabaseConfig();
        this.databaseConfig.setAllowCreate(true);
        this.databaseConfig.setSortedDuplicates(config.isBdbSortedDuplicatesEnabled());
        this.databaseConfig.setNodeMaxEntries(config.getBdbBtreeFanout());
        this.databaseConfig.setTransactional(true);
        this.bdbMasterDir = config.getBdbDataDirectory();
        this.useOneEnvPerStore = config.isBdbOneEnvPerStore();
        if (this.useOneEnvPerStore) {
            this.environmentConfig.setSharedCache(true);
        }
    }

    @Override
    public StorageEngine<ByteArray, byte[]> getStore(String storeName) {
        Object object = this.lock;
        synchronized (object) {
            BdbStorageEngine store = this.stores.get(storeName);
            if (store != null) {
                return this.stores.get(storeName);
            }
            try {
                Environment environment = this.getEnvironment(storeName);
                Database db = environment.openDatabase(null, storeName, this.databaseConfig);
                if (this.voldemortConfig.getBdbCursorPreload()) {
                    PreloadConfig preloadConfig = new PreloadConfig();
                    preloadConfig.setLoadLNs(true);
                    db.preload(preloadConfig);
                }
                BdbStorageEngine engine = new BdbStorageEngine(storeName, environment, db, this.voldemortConfig.getBdbCursorPreload());
                this.stores.put(storeName, engine);
                return engine;
            }
            catch (DatabaseException d) {
                throw new StorageInitializationException(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Environment getEnvironment(String storeName) throws DatabaseException {
        Object object = this.lock;
        synchronized (object) {
            if (this.useOneEnvPerStore) {
                if (this.environments.containsKey(storeName)) {
                    return this.environments.get(storeName);
                }
                File bdbDir = new File(this.bdbMasterDir, storeName);
                this.createBdbDirIfNecessary(bdbDir);
                Environment environment = new Environment(bdbDir, this.environmentConfig);
                logger.info("Creating environment for " + storeName + ": ");
                this.logEnvironmentConfig(environment.getConfig());
                this.environments.put(storeName, environment);
                return environment;
            }
            if (!this.environments.isEmpty()) {
                return this.environments.get(SHARED_ENV_KEY);
            }
            File bdbDir = new File(this.bdbMasterDir);
            this.createBdbDirIfNecessary(bdbDir);
            Environment environment = new Environment(bdbDir, this.environmentConfig);
            logger.info("Creating shared BDB environment: ");
            this.logEnvironmentConfig(environment.getConfig());
            this.environments.put(SHARED_ENV_KEY, environment);
            return environment;
        }
    }

    private void createBdbDirIfNecessary(File bdbDir) {
        if (!bdbDir.exists()) {
            logger.info("Creating BDB data directory '" + bdbDir.getAbsolutePath() + ".");
            bdbDir.mkdirs();
        }
    }

    private void logEnvironmentConfig(EnvironmentConfig config) {
        logger.info("    BDB cache size = " + config.getCacheSize());
        logger.info("    BDB je.cleaner.threads = " + config.getConfigParam("je.cleaner.threads"));
        logger.info("    BDB je.cleaner.minUtilization = " + config.getConfigParam("je.cleaner.minUtilization"));
        logger.info("    BDB je.cleaner.minFileUtilization = " + config.getConfigParam("je.cleaner.minFileUtilization"));
        logger.info("    BDB je.log.fileMax = " + config.getConfigParam("je.log.fileMax"));
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    public EnvironmentStats getStats(String storeName) {
        StatsConfig config = new StatsConfig();
        config.setFast(false);
        try {
            Environment env = this.getEnvironment(storeName);
            return env.getStats(config);
        }
        catch (DatabaseException e) {
            throw new VoldemortException(e);
        }
    }

    @JmxOperation(description="A variety of stats about one BDB environment.")
    public String getEnvStatsAsString(String storeName) throws Exception {
        String envStats = this.getStats(storeName).toString();
        logger.debug("Bdb Environment stats:\n" + envStats);
        return envStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Environment environment : this.environments.values()) {
                    environment.sync();
                    environment.close();
                }
            }
            catch (DatabaseException e) {
                throw new VoldemortException(e);
            }
        }
    }
}

