/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.serialization.SerializerFactory;
import voldemort.store.InvalidMetadataException;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUtils {
    private static Logger logger = Logger.getLogger(StoreUtils.class);

    public static void assertValidKeys(Iterable<?> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys cannot be null.");
        }
        for (Object key : keys) {
            StoreUtils.assertValidKey(key);
        }
    }

    public static <K> void assertValidKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
    }

    public static <K, V> List<Versioned<V>> get(Store<K, V> storageEngine, K key) {
        Map<K, List<Versioned<V>>> result = storageEngine.getAll(Collections.singleton(key));
        if (result.size() > 0) {
            return result.get(key);
        }
        return Collections.emptyList();
    }

    public static <K, V> Map<K, List<Versioned<V>>> getAll(Store<K, V> storageEngine, Iterable<K> keys) {
        HashMap<K, List<Versioned<V>>> result = StoreUtils.newEmptyHashMap(keys);
        for (K key : keys) {
            List<Versioned<V>> value = storageEngine.get(key);
            if (value.isEmpty()) continue;
            result.put(key, value);
        }
        return result;
    }

    public static <K, V> HashMap<K, V> newEmptyHashMap(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return Maps.newHashMapWithExpectedSize(((Collection)iterable).size());
        }
        return Maps.newHashMap();
    }

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                logger.error("Error closing stream", e);
            }
        }
    }

    public static void assertValidMetadata(ByteArray key, RoutingStrategy routingStrategy, Node currentNode) {
        List<Node> nodes = routingStrategy.routeRequest(key.get());
        for (Node node : nodes) {
            if (node.getId() != currentNode.getId()) continue;
            return;
        }
        throw new InvalidMetadataException("client attempt accessing key belonging to partition:" + routingStrategy.getPartitionList(key.get()) + " at Node:" + currentNode);
    }

    public static <V> List<Version> getVersions(List<Versioned<V>> versioneds) {
        ArrayList<Version> versions = Lists.newArrayListWithCapacity(versioneds.size());
        for (Versioned<V> versioned : versioneds) {
            versions.add(versioned.getVersion());
        }
        return versions;
    }

    public static <K, V> ClosableIterator<K> keys(final ClosableIterator<Pair<K, V>> values) {
        return new ClosableIterator<K>(){

            @Override
            public void close() {
                values.close();
            }

            @Override
            public boolean hasNext() {
                return values.hasNext();
            }

            @Override
            public K next() {
                Pair value = (Pair)values.next();
                if (value == null) {
                    return null;
                }
                return value.getFirst();
            }

            @Override
            public void remove() {
                values.remove();
            }
        };
    }

    public static <T> Serializer<T> unsafeGetSerializer(SerializerFactory serializerFactory, SerializerDefinition serializerDefinition) {
        return serializerFactory.getSerializer(serializerDefinition);
    }

    public static StoreDefinition getStoreDef(List<StoreDefinition> list, String name) {
        for (StoreDefinition def : list) {
            if (!def.getName().equals(name)) continue;
            return def;
        }
        return null;
    }
}

