/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store;

import java.util.HashMap;
import java.util.Map;
import voldemort.VoldemortApplicationException;
import voldemort.VoldemortException;
import voldemort.server.rebalance.AlreadyRebalancingException;
import voldemort.server.rebalance.VoldemortRebalancingException;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InvalidMetadataException;
import voldemort.store.PersistenceFailureException;
import voldemort.store.StoreOperationFailureException;
import voldemort.store.UnknownFailure;
import voldemort.store.UnreachableStoreException;
import voldemort.store.rebalancing.ProxyUnreachableException;
import voldemort.store.views.UnsupportedViewOperationException;
import voldemort.utils.ReflectUtils;
import voldemort.versioning.InconsistentDataException;
import voldemort.versioning.ObsoleteVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorCodeMapper {
    private Map<Short, Class<? extends VoldemortException>> codeToException = new HashMap<Short, Class<? extends VoldemortException>>();
    private Map<Class<? extends VoldemortException>, Short> exceptionToCode;

    public ErrorCodeMapper() {
        this.codeToException.put((short)1, VoldemortException.class);
        this.codeToException.put((short)2, InsufficientOperationalNodesException.class);
        this.codeToException.put((short)3, StoreOperationFailureException.class);
        this.codeToException.put((short)4, ObsoleteVersionException.class);
        this.codeToException.put((short)6, UnknownFailure.class);
        this.codeToException.put((short)7, UnreachableStoreException.class);
        this.codeToException.put((short)8, InconsistentDataException.class);
        this.codeToException.put((short)9, InvalidMetadataException.class);
        this.codeToException.put((short)10, PersistenceFailureException.class);
        this.codeToException.put((short)11, UnsupportedViewOperationException.class);
        this.codeToException.put((short)12, VoldemortApplicationException.class);
        this.codeToException.put((short)13, AlreadyRebalancingException.class);
        this.codeToException.put((short)14, VoldemortRebalancingException.class);
        this.codeToException.put((short)15, ProxyUnreachableException.class);
        this.exceptionToCode = new HashMap<Class<? extends VoldemortException>, Short>();
        for (Map.Entry<Short, Class<? extends VoldemortException>> entry : this.codeToException.entrySet()) {
            this.exceptionToCode.put(entry.getValue(), entry.getKey());
        }
    }

    public VoldemortException getError(short code, String message) {
        Class<? extends VoldemortException> klass = this.codeToException.get(code);
        if (klass == null) {
            return new UnknownFailure(Integer.toString(code));
        }
        return ReflectUtils.callConstructor(klass, new Object[]{message});
    }

    public short getCode(VoldemortException e) {
        return this.getCode(e.getClass());
    }

    public short getCode(Class<? extends VoldemortException> c) {
        Short code = this.exceptionToCode.get(c);
        if (code == null) {
            throw new IllegalArgumentException("No mapping code for " + c);
        }
        return code;
    }
}

