/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingStore<K, V>
implements Store<K, V> {
    private final Store<K, V> innerStore;

    public DelegatingStore(Store<K, V> innerStore) {
        this.innerStore = Utils.notNull(innerStore);
    }

    @Override
    public void close() throws VoldemortException {
        this.innerStore.close();
    }

    @Override
    public boolean delete(K key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.innerStore.delete(key, version);
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        return this.innerStore.getAll(keys);
    }

    @Override
    public List<Versioned<V>> get(K key) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.innerStore.get(key);
    }

    @Override
    public String getName() {
        return this.innerStore.getName();
    }

    @Override
    public void put(K key, Versioned<V> value) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        this.innerStore.put(key, value);
    }

    public Store<K, V> getInnerStore() {
        return this.innerStore;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        return this.innerStore.getCapability(capability);
    }

    public String toString() {
        return this.innerStore.toString();
    }

    @Override
    public List<Version> getVersions(K key) {
        return this.innerStore.getVersions(key);
    }
}

