/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.storage;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.ClientThreadPool;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.FailureDetectorUtils;
import voldemort.cluster.failuredetector.ServerStoreVerifier;
import voldemort.serialization.ByteArraySerializer;
import voldemort.serialization.SlopSerializer;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.scheduler.DataCleanupJob;
import voldemort.server.scheduler.SchedulerService;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.invalidmetadata.InvalidMetadataCheckingStore;
import voldemort.store.logging.LoggingStore;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.rebalancing.RebootstrappingStore;
import voldemort.store.rebalancing.RedirectingStore;
import voldemort.store.routed.RoutedStore;
import voldemort.store.serialized.SerializingStorageEngine;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketPool;
import voldemort.store.socket.SocketStore;
import voldemort.store.stats.DataSetStats;
import voldemort.store.stats.StatTrackingStore;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.StoreStatsJmx;
import voldemort.store.versioned.InconsistencyResolvingStore;
import voldemort.store.views.ViewStorageConfiguration;
import voldemort.store.views.ViewStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.ConfigurationException;
import voldemort.utils.EventThrottler;
import voldemort.utils.JmxUtils;
import voldemort.utils.Pair;
import voldemort.utils.ReflectUtils;
import voldemort.utils.SystemTime;
import voldemort.versioning.VectorClock;
import voldemort.versioning.VectorClockInconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="Start and stop all stores.")
public class StorageService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(StorageService.class.getName());
    private final VoldemortConfig voldemortConfig;
    private final StoreRepository storeRepository;
    private final SchedulerService scheduler;
    private final MetadataStore metadata;
    private final Semaphore cleanupPermits;
    private final SocketPool socketPool;
    private final ConcurrentMap<String, StorageConfiguration> storageConfigs;
    private final ClientThreadPool clientThreadPool;
    private final FailureDetector failureDetector;
    private final StoreStats storeStats;

    public StorageService(StoreRepository storeRepository, MetadataStore metadata, SchedulerService scheduler, VoldemortConfig config) {
        super(ServiceType.STORAGE);
        this.voldemortConfig = config;
        this.scheduler = scheduler;
        this.storeRepository = storeRepository;
        this.metadata = metadata;
        this.cleanupPermits = new Semaphore(1);
        this.storageConfigs = new ConcurrentHashMap<String, StorageConfiguration>();
        this.clientThreadPool = new ClientThreadPool(config.getClientMaxThreads(), config.getClientThreadIdleMs(), config.getClientMaxQueuedRequests());
        this.socketPool = new SocketPool(config.getClientMaxConnectionsPerNode(), config.getClientConnectionTimeoutMs(), config.getSocketTimeoutMs(), config.getSocketBufferSize(), config.getSocketKeepAlive());
        FailureDetectorConfig failureDetectorConfig = new FailureDetectorConfig(this.voldemortConfig).setNodes(metadata.getCluster().getNodes()).setStoreVerifier(new ServerStoreVerifier(this.socketPool, metadata, config));
        this.failureDetector = FailureDetectorUtils.create(failureDetectorConfig, config.isJmxEnabled(), new FailureDetectorListener[0]);
        this.storeStats = new StoreStats();
    }

    private void initStorageConfig(String configClassName) {
        try {
            Class<?> configClass = ReflectUtils.loadClass(configClassName);
            StorageConfiguration configuration = (StorageConfiguration)ReflectUtils.callConstructor(configClass, new Class[]{VoldemortConfig.class}, new Object[]{this.voldemortConfig});
            logger.info("Initializing " + configuration.getType() + " storage engine.");
            this.storageConfigs.put(configuration.getType(), configuration);
            if (this.voldemortConfig.isJmxEnabled()) {
                JmxUtils.registerMbean(configuration.getType() + "StorageConfiguration", configuration);
            }
        }
        catch (IllegalStateException e) {
            logger.error("Error loading storage configuration '" + configClassName + "'.", e);
        }
        if (this.storageConfigs.size() == 0) {
            throw new ConfigurationException("No storage engine has been enabled!");
        }
    }

    @Override
    protected void startInner() {
        this.registerEngine(this.metadata);
        for (String configClassName : this.voldemortConfig.getStorageConfigurations()) {
            this.initStorageConfig(configClassName);
        }
        this.storageConfigs.put(ViewStorageConfiguration.TYPE_NAME, new ViewStorageConfiguration(this.voldemortConfig, this.metadata.getStoreDefList(), this.storeRepository));
        if (this.voldemortConfig.isSlopEnabled()) {
            StorageEngine<ByteArray, byte[]> slopEngine = this.getStorageEngine("slop", this.voldemortConfig.getSlopStoreType());
            this.registerEngine(slopEngine);
            this.storeRepository.setSlopStore(SerializingStorageEngine.wrap(slopEngine, new ByteArraySerializer(), new SlopSerializer()));
        }
        ArrayList<StoreDefinition> storeDefs = new ArrayList<StoreDefinition>(this.metadata.getStoreDefList());
        logger.info("Initializing stores:");
        for (StoreDefinition def : storeDefs) {
            if (def.isView()) continue;
            this.openStore(def);
        }
        for (StoreDefinition def : storeDefs) {
            if (!def.isView()) continue;
            this.openStore(def);
        }
        if (this.voldemortConfig.isStatTrackingEnabled()) {
            JmxUtils.registerMbean(new StoreStatsJmx(this.storeStats), JmxUtils.createObjectName("voldemort.store.stats.aggregate", "aggregate-perf"));
        }
        logger.info("All stores initialized.");
    }

    public void openStore(StoreDefinition storeDef) {
        logger.info("Opening store '" + storeDef.getName() + "' (" + storeDef.getType() + ").");
        StorageEngine<ByteArray, byte[]> engine = this.getStorageEngine(storeDef.getName(), storeDef.getType());
        this.registerEngine(engine);
        if (this.voldemortConfig.isServerRoutingEnabled()) {
            this.registerNodeStores(storeDef, this.metadata.getCluster(), this.voldemortConfig.getNodeId());
        }
        if (storeDef.hasRetentionPeriod()) {
            this.scheduleCleanupJob(storeDef, engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEngine(StorageEngine<ByteArray, byte[]> engine) {
        Cluster cluster = this.metadata.getCluster();
        this.storeRepository.addStorageEngine(engine);
        Store<ByteArray, Object> store = engine;
        if (this.voldemortConfig.isVerboseLoggingEnabled()) {
            store = new LoggingStore<ByteArray, byte[]>(store, cluster.getName(), SystemTime.INSTANCE);
        }
        if (this.voldemortConfig.isRedirectRoutingEnabled()) {
            store = new RedirectingStore(store, this.metadata, this.storeRepository, this.failureDetector, this.socketPool);
        }
        if (this.voldemortConfig.isMetadataCheckingEnabled()) {
            store = new InvalidMetadataCheckingStore(this.metadata.getNodeId(), store, this.metadata);
        }
        if (this.voldemortConfig.isStatTrackingEnabled()) {
            StatTrackingStore<ByteArray, byte[]> statStore = new StatTrackingStore<ByteArray, byte[]>(store, this.storeStats);
            store = statStore;
            if (this.voldemortConfig.isJmxEnabled()) {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = JmxUtils.createObjectName(JmxUtils.getPackageName(store.getClass()), store.getName());
                MBeanServer mBeanServer = mbeanServer;
                synchronized (mBeanServer) {
                    if (mbeanServer.isRegistered(name)) {
                        JmxUtils.unregisterMbean(mbeanServer, name);
                    }
                    JmxUtils.registerMbean(mbeanServer, JmxUtils.createModelMBean(new StoreStatsJmx(statStore.getStats())), name);
                }
            }
        }
        this.storeRepository.addLocalStore(store);
    }

    public void registerNodeStores(StoreDefinition def, Cluster cluster, int localNode) {
        HashMap<Integer, Store<ByteArray, byte[]>> nodeStores = new HashMap<Integer, Store<ByteArray, byte[]>>(cluster.getNumberOfNodes());
        for (Node node : cluster.getNodes()) {
            Store<ByteArray, byte[]> store = this.getNodeStore(def.getName(), node, localNode);
            this.storeRepository.addNodeStore(node.getId(), store);
            nodeStores.put(node.getId(), store);
        }
        Store<ByteArray, byte[]> routedStore = new RoutedStore(def.getName(), nodeStores, this.metadata.getCluster(), def, true, this.clientThreadPool, this.voldemortConfig.getRoutingTimeoutMs(), this.failureDetector, SystemTime.INSTANCE);
        routedStore = new RebootstrappingStore(this.metadata, this.storeRepository, this.voldemortConfig, this.socketPool, (RoutedStore)routedStore);
        routedStore = new InconsistencyResolvingStore<ByteArray, byte[]>(routedStore, new VectorClockInconsistencyResolver());
        this.storeRepository.addRoutedStore(routedStore);
    }

    private Store<ByteArray, byte[]> getNodeStore(String storeName, Node node, int localNode) {
        Store<ByteArray, byte[]> store = node.getId() == localNode ? this.storeRepository.getLocalStore(storeName) : this.createNodeStore(storeName, node);
        return store;
    }

    private Store<ByteArray, byte[]> createNodeStore(String storeName, Node node) {
        return new SocketStore(storeName, new SocketDestination(node.getHost(), node.getSocketPort(), this.voldemortConfig.getRequestFormatType()), this.socketPool, false);
    }

    private void scheduleCleanupJob(StoreDefinition storeDef, StorageEngine<ByteArray, byte[]> engine) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(6, 1);
        cal.set(11, this.voldemortConfig.getRetentionCleanupFirstStartTimeInHour());
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date startTime = cal.getTime();
        int maxReadRate = storeDef.hasRetentionScanThrottleRate() ? storeDef.getRetentionScanThrottleRate() : Integer.MAX_VALUE;
        logger.info("Scheduling data retention cleanup job for store '" + storeDef.getName() + "' at " + startTime + " with retention scan throttle rate:" + maxReadRate + " Entries/second.");
        EventThrottler throttler = new EventThrottler(maxReadRate);
        DataCleanupJob<ByteArray, byte[]> cleanupJob = new DataCleanupJob<ByteArray, byte[]>(engine, this.cleanupPermits, (long)storeDef.getRetentionDays().intValue() * 86400000L, SystemTime.INSTANCE, throttler);
        this.scheduler.schedule(cleanupJob, startTime, (long)this.voldemortConfig.getRetentionCleanupScheduledPeriodInHour() * 3600000L);
    }

    private StorageEngine<ByteArray, byte[]> getStorageEngine(String name, String type) {
        StorageConfiguration config = (StorageConfiguration)this.storageConfigs.get(type);
        if (config == null) {
            throw new ConfigurationException("Attempt to open store " + name + " but " + type + " storage engine of type " + type + " has not been enabled.");
        }
        return config.getStore(name);
    }

    @Override
    protected void stopInner() {
        Exception lastException = null;
        logger.info("Closing all stores.");
        for (Store<ByteArray, byte[]> store : this.storeRepository.getAllRoutedStores()) {
            logger.info("Closing routed store for " + store.getName());
            try {
                store.close();
            }
            catch (Exception e) {
                logger.error(e);
                lastException = e;
            }
        }
        for (StorageEngine storageEngine : this.storeRepository.getAllStorageEngines()) {
            logger.info("Closing storage engine for " + storageEngine.getName());
            try {
                storageEngine.close();
            }
            catch (Exception e) {
                logger.error(e);
                lastException = e;
            }
        }
        logger.info("All stores closed.");
        if (this.storeRepository.hasSlopStore()) {
            try {
                this.storeRepository.getSlopStore().close();
            }
            catch (Exception e) {
                logger.error(e);
                lastException = e;
            }
        }
        logger.info("Closing storage configurations.");
        for (StorageConfiguration storageConfiguration : this.storageConfigs.values()) {
            logger.info("Closing " + storageConfiguration.getType() + " storage config.");
            try {
                storageConfiguration.close();
            }
            catch (Exception e) {
                logger.error(e);
                lastException = e;
            }
        }
        this.clientThreadPool.shutdownNow();
        logger.info("Closed client threadpool.");
        if (this.failureDetector != null) {
            try {
                this.failureDetector.destroy();
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        logger.info("Closed failure detector.");
        if (lastException instanceof VoldemortException) {
            throw (VoldemortException)lastException;
        }
        if (lastException != null) {
            throw new VoldemortException(lastException);
        }
    }

    public MetadataStore getMetadataStore() {
        return this.metadata;
    }

    public StoreRepository getStoreRepository() {
        return this.storeRepository;
    }

    @JmxOperation(description="Force cleanup of old data based on retention policy, allows override of throttle-rate", impact=1)
    public void forceCleanupOldData(String storeName) {
        StoreDefinition storeDef = this.getMetadataStore().getStoreDef(storeName);
        int throttleRate = storeDef.hasRetentionScanThrottleRate() ? storeDef.getRetentionScanThrottleRate() : Integer.MAX_VALUE;
        this.forceCleanupOldDataThrottled(storeName, throttleRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="Force cleanup of old data based on retention policy.", impact=1)
    public void forceCleanupOldDataThrottled(String storeName, int entryScanThrottleRate) {
        block8: {
            logger.info("forceCleanupOldData() called for store " + storeName + " with retention scan throttle rate:" + entryScanThrottleRate + " Entries/second.");
            try {
                StoreDefinition storeDef = this.getMetadataStore().getStoreDef(storeName);
                StorageEngine<ByteArray, byte[]> engine = this.storeRepository.getStorageEngine(storeName);
                if (null == engine) break block8;
                if (storeDef.hasRetentionPeriod()) {
                    ExecutorService executor = Executors.newFixedThreadPool(1);
                    try {
                        if (this.cleanupPermits.availablePermits() >= 1) {
                            executor.execute(new DataCleanupJob<ByteArray, byte[]>(engine, this.cleanupPermits, (long)storeDef.getRetentionDays().intValue() * 86400000L, SystemTime.INSTANCE, new EventThrottler(entryScanThrottleRate)));
                        } else {
                            logger.error("forceCleanupOldData() No permit available to run cleanJob already running multiple instance." + engine.getName());
                        }
                        break block8;
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                logger.error("forceCleanupOldData() No retention policy found for " + storeName);
            }
            catch (Exception e) {
                logger.error("Error while running forceCleanupOldData()", e);
                throw new VoldemortException(e);
            }
        }
    }

    @JmxOperation(description="Print stats on a given store", impact=1)
    public void logStoreStats(final String storeName) {
        this.scheduler.scheduleNow(new Runnable(){

            public void run() {
                StorageEngine<ByteArray, byte[]> store = StorageService.this.storeRepository.getStorageEngine(storeName);
                if (store == null) {
                    logger.error("Invalid store name '" + storeName + "'.");
                    return;
                }
                logger.info("Data statistics for store '" + store.getName() + "':\n\n" + StorageService.this.calculateStats(store) + "\n\n");
            }
        });
    }

    @JmxOperation(description="Print stats on a given store", impact=1)
    public void logStoreStats() {
        this.scheduler.scheduleNow(new Runnable(){

            public void run() {
                try {
                    DataSetStats totals = new DataSetStats();
                    ArrayList<String> names = new ArrayList<String>();
                    ArrayList<DataSetStats> stats = new ArrayList<DataSetStats>();
                    for (StorageEngine<ByteArray, byte[]> store : StorageService.this.storeRepository.getAllStorageEngines()) {
                        if (store instanceof ReadOnlyStorageEngine || store instanceof ViewStorageEngine || store instanceof MetadataStore) continue;
                        logger.info(store.getClass());
                        logger.info("Calculating stats for '" + store.getName() + "'...");
                        DataSetStats curr = StorageService.this.calculateStats(store);
                        names.add(store.getName());
                        stats.add(curr);
                        totals.add(curr);
                    }
                    for (int i = 0; i < names.size(); ++i) {
                        logger.info("\n\nData statistics for store '" + (String)names.get(i) + "':\n" + stats.get(i) + "\n\n");
                    }
                    logger.info("Totals: \n " + totals + "\n\n");
                }
                catch (Exception e) {
                    logger.error("Error in thread: ", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSetStats calculateStats(StorageEngine<ByteArray, byte[]> store) {
        DataSetStats stats = new DataSetStats();
        ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iter = store.entries();
        try {
            int count = 0;
            while (iter.hasNext()) {
                Pair pair = (Pair)iter.next();
                VectorClock clock = (VectorClock)((Versioned)pair.getSecond()).getVersion();
                stats.countEntry(((ByteArray)pair.getFirst()).length(), ((byte[])((Versioned)pair.getSecond()).getValue()).length + clock.sizeInBytes());
                if (count % 10000 == 0) {
                    logger.debug("Processing key " + count);
                }
                ++count;
            }
        }
        finally {
            iter.close();
        }
        return stats;
    }

    public SocketPool getStorageSocketPool() {
        return this.socketPool;
    }
}

