/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.StatusManager;
import voldemort.server.protocol.RequestHandlerFactory;
import voldemort.server.socket.SocketServerSession;

@JmxManaged
public class SocketServer
extends Thread {
    private final Logger logger;
    private static final Object SUCCESS = new Object();
    private final BlockingQueue<Object> startedStatusQueue = new LinkedBlockingQueue<Object>();
    private final ThreadPoolExecutor threadPool;
    private final int port;
    private final ThreadGroup threadGroup;
    private final int socketBufferSize;
    private final RequestHandlerFactory handlerFactory;
    private final int maxThreads;
    private final StatusManager statusManager;
    private final AtomicLong sessionIdSequence;
    private final ConcurrentMap<Long, SocketServerSession> activeSessions;
    private final String serverName;
    private ServerSocket serverSocket = null;
    private final ThreadFactory threadFactory = new ThreadFactory(){
        private AtomicLong threadIdSequence = new AtomicLong(0L);

        public Thread newThread(Runnable r) {
            String name = "voldemort-server-" + this.threadIdSequence.getAndIncrement();
            Thread t = new Thread(SocketServer.this.threadGroup, r, name);
            t.setDaemon(true);
            return t;
        }
    };
    private final RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            SocketServerSession session = (SocketServerSession)r;
            if (Thread.interrupted()) {
                SocketServer.this.logger.info("Denying connection from " + session.getSocket().getRemoteSocketAddress() + ", server is shutting down.");
            } else {
                SocketServer.this.logger.error("Too many open connections, " + executor.getActiveCount() + " of " + executor.getLargestPoolSize() + " threads in use, denying connection from " + session.getSocket().getRemoteSocketAddress());
            }
            try {
                session.getSocket().close();
            }
            catch (IOException e) {
                SocketServer.this.logger.error("Could not close socket.", e);
            }
        }
    };

    public SocketServer(int port, int defaultThreads, int maxThreads, int socketBufferSize, RequestHandlerFactory handlerFactory, String serverName) {
        this.port = port;
        this.socketBufferSize = socketBufferSize;
        this.threadGroup = new ThreadGroup("voldemort-socket-server");
        this.handlerFactory = handlerFactory;
        this.maxThreads = maxThreads;
        this.threadPool = new ThreadPoolExecutor(defaultThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), this.threadFactory, this.rejectedExecutionHandler);
        this.statusManager = new StatusManager(this.threadPool);
        this.sessionIdSequence = new AtomicLong(0L);
        this.activeSessions = new ConcurrentHashMap<Long, SocketServerSession>();
        this.serverName = serverName;
        this.logger = Logger.getLogger(SocketServer.class.getName() + "[" + serverName + "]");
    }

    public void run() {
        this.logger.info("Starting voldemort socket server (" + this.serverName + ") on port " + this.port);
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(this.port));
            this.serverSocket.setReceiveBufferSize(this.socketBufferSize);
            this.startedStatusQueue.put(SUCCESS);
            while (!this.isInterrupted() && !this.serverSocket.isClosed()) {
                Socket socket = this.serverSocket.accept();
                this.configureSocket(socket);
                long sessionId = this.sessionIdSequence.getAndIncrement();
                this.threadPool.execute(new SocketServerSession(this.activeSessions, socket, this.handlerFactory, sessionId));
            }
        }
        catch (BindException e) {
            this.logger.error("Could not bind to port " + this.port + ".");
            this.startedStatusQueue.offer(e);
            throw new VoldemortException(e);
        }
        catch (SocketException e) {
            this.startedStatusQueue.offer(e);
            if (!this.isInterrupted()) {
                this.logger.error("Error in server: ", e);
            }
        }
        catch (IOException e) {
            this.startedStatusQueue.offer(e);
            throw new VoldemortException(e);
        }
        catch (Throwable t) {
            this.logger.error(t);
            this.startedStatusQueue.offer(t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new VoldemortException(t);
        }
        finally {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    this.logger.warn("Error while shutting down server.", e);
                }
            }
        }
    }

    private void configureSocket(Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
        socket.setSendBufferSize(this.socketBufferSize);
        if (socket.getReceiveBufferSize() != this.socketBufferSize) {
            this.logger.debug("Requested socket receive buffer size was " + this.socketBufferSize + " bytes but actual size is " + socket.getReceiveBufferSize() + " bytes.");
        }
        if (socket.getSendBufferSize() != this.socketBufferSize) {
            this.logger.debug("Requested socket send buffer size was " + this.socketBufferSize + " bytes but actual size is " + socket.getSendBufferSize() + " bytes.");
        }
    }

    public void shutdown() {
        this.logger.info("Shutting down voldemort socket server (" + this.serverName + ").");
        this.interrupt();
        try {
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error while closing socket server: " + e.getMessage());
        }
        this.threadPool.shutdownNow();
        this.killActiveSessions();
        try {
            boolean completed = this.threadPool.awaitTermination(5L, TimeUnit.SECONDS);
            if (!completed) {
                this.logger.warn("Timed out waiting for threadpool to close.");
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted while waiting for socket server shutdown to complete: ", e);
        }
    }

    @JmxOperation(description="Kill all the active sessions.")
    public void killActiveSessions() {
        this.logger.info("Killing all active sessions.");
        for (Map.Entry entry : this.activeSessions.entrySet()) {
            try {
                this.logger.debug("Closing session " + entry.getKey());
                ((SocketServerSession)entry.getValue()).close();
            }
            catch (IOException e) {
                this.logger.warn("Error while closing session socket: ", e);
            }
        }
    }

    @JmxGetter(name="port", description="The port on which the server accepts connections.")
    public int getPort() {
        return this.port;
    }

    @JmxGetter(name="maxThreads", description="The maximum number of threads that can be started on the server.")
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JmxGetter(name="currentThreads", description="The current number of utilized threads on the server.")
    public int getCurrentThreads() {
        return this.threadPool.getActiveCount();
    }

    @JmxGetter(name="remainingThreadCapacity", description="The number of additional threads that can be allocated before reaching the maximum.")
    public int getRemainingThreads() {
        return this.getMaxThreads() - this.getCurrentThreads();
    }

    public void awaitStartupCompletion() {
        try {
            Object obj = this.startedStatusQueue.take();
            if (obj instanceof Throwable) {
                throw new VoldemortException((Throwable)obj);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public StatusManager getStatusManager() {
        return this.statusManager;
    }
}

