/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import voldemort.server.StoreRepository;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Versioned;

public class SlopPusherJob
implements Runnable {
    private static final Logger logger = Logger.getLogger(SlopPusherJob.class.getName());
    private final StoreRepository storeRepo;

    public SlopPusherJob(StoreRepository storeRepo) {
        this.storeRepo = storeRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.debug("Pushing slop...");
        int slopsPushed = 0;
        int attemptedPushes = 0;
        ClosableIterator<Pair<ByteArray, Versioned<Slop>>> iterator = null;
        try {
            StorageEngine<ByteArray, Slop> slopStore = this.storeRepo.getSlopStore();
            iterator = slopStore.entries();
            while (iterator.hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Task cancelled!");
                }
                ++attemptedPushes;
                try {
                    Pair keyAndVal = (Pair)iterator.next();
                    Versioned versioned = (Versioned)keyAndVal.getSecond();
                    Slop slop = (Slop)versioned.getValue();
                    Store<ByteArray, byte[]> store = this.storeRepo.getNodeStore(slop.getStoreName(), slop.getNodeId());
                    try {
                        if (slop.getOperation() == Slop.Operation.PUT) {
                            store.put((ByteArray)keyAndVal.getFirst(), new Versioned<byte[]>(slop.getValue(), versioned.getVersion()));
                        } else if (slop.getOperation() == Slop.Operation.DELETE) {
                            store.delete((ByteArray)keyAndVal.getFirst(), versioned.getVersion());
                        } else {
                            logger.error("Unknown slop operation: " + (Object)((Object)slop.getOperation()));
                        }
                        slopStore.delete(slop.makeKey(), versioned.getVersion());
                        ++slopsPushed;
                    }
                    catch (ObsoleteVersionException e) {
                        slopStore.delete(slop.makeKey(), versioned.getVersion());
                    }
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            try {
                if (iterator != null) {
                    iterator.close();
                }
            }
            catch (Exception e) {
                logger.error("Failed to close iterator.", e);
            }
        }
        logger.log(attemptedPushes > 0 ? Level.INFO : Level.DEBUG, "Attempted " + attemptedPushes + " hinted handoff pushes of which " + slopsPushed + " succeeded.");
    }
}

