/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler;

import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.utils.Time;

@JmxManaged(description="A service that runs scheduled jobs.")
public class SchedulerService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(SchedulerService.class.getName());
    private final ScheduledThreadPoolExecutor scheduler;
    private final Time time;

    public SchedulerService(int schedulerThreads, Time time) {
        super(ServiceType.SCHEDULER);
        this.time = time;
        this.scheduler = new SchedulerThreadPool(schedulerThreads);
    }

    public void startInner() {
    }

    public void stopInner() {
        this.scheduler.shutdownNow();
    }

    public void scheduleNow(Runnable runnable) {
        this.scheduler.execute(runnable);
    }

    public void schedule(Runnable runnable, Date timeToRun) {
        this.scheduler.schedule(runnable, this.delayMs(timeToRun), TimeUnit.MILLISECONDS);
    }

    public void schedule(Runnable runnable, Date nextRun, long periodMs) {
        this.scheduler.scheduleAtFixedRate(runnable, this.delayMs(nextRun), periodMs, TimeUnit.MILLISECONDS);
    }

    private long delayMs(Date runDate) {
        return Math.max(0L, runDate.getTime() - this.time.getMilliseconds());
    }

    private static class SchedulerThreadPool
    extends ScheduledThreadPoolExecutor {
        public SchedulerThreadPool(int numThreads) {
            super(numThreads, new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(r.getClass().getName());
                    return thread;
                }
            });
        }
    }
}

