/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.rebalance;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.serialization.json.JsonReader;
import voldemort.serialization.json.JsonWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalancerState {
    private final Map<Integer, RebalancePartitionsInfo> stealInfoMap;

    public RebalancerState(List<RebalancePartitionsInfo> stealInfoList) {
        this.stealInfoMap = Maps.newHashMapWithExpectedSize(stealInfoList.size());
        for (RebalancePartitionsInfo rebalancePartitionsInfo : stealInfoList) {
            this.stealInfoMap.put(rebalancePartitionsInfo.getDonorId(), rebalancePartitionsInfo);
        }
    }

    public static RebalancerState create(String json) {
        LinkedList<RebalancePartitionsInfo> stealInfoList = Lists.newLinkedList();
        JsonReader reader = new JsonReader(new StringReader(json));
        for (Object o : reader.readArray()) {
            Map m = (Map)o;
            stealInfoList.add(RebalancePartitionsInfo.create(m));
        }
        return new RebalancerState(stealInfoList);
    }

    public String toJsonString() {
        LinkedList<ImmutableMap<String, Object>> maps = Lists.newLinkedList();
        for (RebalancePartitionsInfo rebalancePartitionsInfo : this.stealInfoMap.values()) {
            maps.add(rebalancePartitionsInfo.asMap());
        }
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter).write(maps);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public boolean isEmpty() {
        return this.stealInfoMap.isEmpty();
    }

    public boolean remove(RebalancePartitionsInfo rebalancePartitionsInfo) {
        RebalancePartitionsInfo prev = this.stealInfoMap.remove(rebalancePartitionsInfo.getDonorId());
        return prev != null;
    }

    public boolean update(RebalancePartitionsInfo rebalancePartitionsInfo) {
        if (!this.stealInfoMap.containsKey(rebalancePartitionsInfo.getDonorId())) {
            return false;
        }
        this.add(rebalancePartitionsInfo);
        return true;
    }

    public void add(RebalancePartitionsInfo rebalancePartitionsInfo) {
        this.stealInfoMap.put(rebalancePartitionsInfo.getDonorId(), rebalancePartitionsInfo);
    }

    public Collection<RebalancePartitionsInfo> getAll() {
        return this.stealInfoMap.values();
    }

    public RebalancePartitionsInfo find(String store, List<Integer> partitionIds) {
        for (int p : partitionIds) {
            for (RebalancePartitionsInfo info : this.getAll()) {
                if (!info.getUnbalancedStoreList().contains(store) || !info.getPartitionList().contains(p)) continue;
                return info;
            }
        }
        return null;
    }

    public RebalancePartitionsInfo find(int donorId) {
        return this.stealInfoMap.get(donorId);
    }

    public List<RebalancePartitionsInfo> find(String store) {
        ArrayList<RebalancePartitionsInfo> stealInfoList = Lists.newArrayListWithExpectedSize(this.stealInfoMap.size());
        for (RebalancePartitionsInfo info : this.getAll()) {
            if (!info.getUnbalancedStoreList().contains(store)) continue;
            stealInfoList.add(info);
        }
        return stealInfoList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RebalancerState that = (RebalancerState)o;
        return ((Object)this.stealInfoMap).equals(that.stealInfoMap);
    }

    public int hashCode() {
        return ((Object)this.stealInfoMap).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RebalancerState(operations: ");
        sb.append("\n");
        for (RebalancePartitionsInfo info : this.getAll()) {
            sb.append(info);
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }
}

