/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.rebalance;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.rebalance.AlreadyRebalancingException;
import voldemort.server.rebalance.RebalanceAsyncOperation;
import voldemort.server.rebalance.RebalancerState;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;

public class Rebalancer
implements Runnable {
    private static final Logger logger = Logger.getLogger(Rebalancer.class);
    private final MetadataStore metadataStore;
    private final AsyncOperationService asyncService;
    private final VoldemortConfig voldemortConfig;
    private final Set<Integer> rebalancePermits = Collections.synchronizedSet(new HashSet());

    public Rebalancer(MetadataStore metadataStore, VoldemortConfig voldemortConfig, AsyncOperationService asyncService) {
        this.metadataStore = metadataStore;
        this.asyncService = asyncService;
        this.voldemortConfig = voldemortConfig;
    }

    public void start() {
    }

    public void stop() {
    }

    private boolean acquireRebalancingPermit(int donorNodeId) {
        return this.rebalancePermits.add(donorNodeId);
    }

    protected void releaseRebalancingPermit(int donorNodeId) {
        if (!this.rebalancePermits.remove(donorNodeId)) {
            throw new VoldemortException(new IllegalStateException("Invalid state, must hold a permit to release"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RebalancerState rebalancerState;
        MetadataStore.VoldemortState voldemortState;
        logger.debug("rebalancer run() called.");
        this.metadataStore.readLock.lock();
        try {
            voldemortState = this.metadataStore.getServerState();
            rebalancerState = this.metadataStore.getRebalancerState();
        }
        catch (Exception e) {
            logger.error("Error determining state", e);
            return;
        }
        finally {
            this.metadataStore.readLock.unlock();
        }
        if (MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER.equals((Object)voldemortState)) {
            for (RebalancePartitionsInfo stealInfo : rebalancerState.getAll()) {
                if (!this.acquireRebalancingPermit(stealInfo.getDonorId())) continue;
                this.releaseRebalancingPermit(stealInfo.getDonorId());
                try {
                    logger.warn("Rebalance server found incomplete rebalancing attempt, restarting rebalancing task " + stealInfo);
                    if (stealInfo.getAttempt() < this.voldemortConfig.getMaxRebalancingAttempt()) {
                        this.attemptRebalance(stealInfo);
                        continue;
                    }
                    logger.warn("Rebalancing for rebalancing task " + stealInfo + " failed multiple times, Aborting more trials.");
                    this.metadataStore.cleanRebalancingState(stealInfo);
                }
                catch (Exception e) {
                    logger.error("RebalanceService rebalancing attempt " + stealInfo + " failed with exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptRebalance(RebalancePartitionsInfo stealInfo) {
        stealInfo.setAttempt(stealInfo.getAttempt() + 1);
        AdminClient adminClient = RebalanceUtils.createTempAdminClient(this.voldemortConfig, this.metadataStore.getCluster(), 4, 2);
        try {
            int rebalanceAsyncId = this.rebalanceLocalNode(stealInfo);
            adminClient.waitForCompletion(stealInfo.getStealerId(), rebalanceAsyncId, this.voldemortConfig.getAdminSocketTimeout(), TimeUnit.SECONDS);
        }
        finally {
            adminClient.stop();
        }
    }

    public int rebalanceLocalNode(RebalancePartitionsInfo stealInfo) {
        RebalancerState rebalancerState;
        RebalancePartitionsInfo info;
        if (!this.acquireRebalancingPermit(stealInfo.getDonorId()) && (info = (rebalancerState = this.metadataStore.getRebalancerState()).find(stealInfo.getDonorId())) != null) {
            throw new AlreadyRebalancingException("Node " + this.metadataStore.getCluster().getNodeById(info.getStealerId()) + " is already rebalancing from " + info.getDonorId() + " rebalanceInfo:" + info);
        }
        this.checkCurrentState(stealInfo);
        this.setRebalancingState(stealInfo);
        int maxParallelStoresRebalancing = -1 != this.voldemortConfig.getMaxParallelStoresRebalancing() ? this.voldemortConfig.getMaxParallelStoresRebalancing() : stealInfo.getUnbalancedStoreList().size();
        int requestId = this.asyncService.getUniqueRequestId();
        this.asyncService.submitOperation(requestId, new RebalanceAsyncOperation(this, this.voldemortConfig, this.metadataStore, requestId, stealInfo, maxParallelStoresRebalancing));
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRebalancingState(RebalancePartitionsInfo stealInfo) {
        this.metadataStore.writeLock.lock();
        try {
            this.metadataStore.put("server.state", (Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER);
            RebalancerState rebalancerState = this.metadataStore.getRebalancerState();
            rebalancerState.add(stealInfo);
            this.metadataStore.put("rebalancing.steal.info.key", rebalancerState);
        }
        finally {
            this.metadataStore.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCurrentState(RebalancePartitionsInfo stealInfo) {
        this.metadataStore.readLock.lock();
        try {
            RebalancerState rebalancerState;
            RebalancePartitionsInfo info;
            if (this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER) && (info = (rebalancerState = this.metadataStore.getRebalancerState()).find(stealInfo.getDonorId())) != null) {
                throw new VoldemortException("Server " + this.metadataStore.getNodeId() + " is already rebalancing from: " + info + " rejecting rebalance request:" + stealInfo);
            }
        }
        finally {
            this.metadataStore.readLock.unlock();
        }
    }
}

