/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.protobuf.Message;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.VoldemortFilter;
import voldemort.client.protocol.admin.filter.DefaultVoldemortFilter;
import voldemort.client.protocol.admin.filter.MasterOnlyVoldemortFilter;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.routing.RoutingStrategy;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.AdminServiceRequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StorageEngine;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.NetworkClassLoader;

public abstract class FetchStreamRequestHandler
implements StreamRequestHandler {
    protected final VAdminProto.FetchPartitionEntriesRequest request;
    protected final ErrorCodeMapper errorCodeMapper;
    protected final RoutingStrategy routingStrategy;
    protected final EventThrottler throttler;
    protected final List<Integer> partitionList;
    protected final VoldemortFilter filter;
    protected final StorageEngine<ByteArray, byte[]> storageEngine;
    protected final ClosableIterator<ByteArray> keyIterator;
    protected int counter;
    protected int fetched;
    protected final long startTime;
    protected final Logger logger = Logger.getLogger(this.getClass());

    protected FetchStreamRequestHandler(VAdminProto.FetchPartitionEntriesRequest request, MetadataStore metadataStore, ErrorCodeMapper errorCodeMapper, VoldemortConfig voldemortConfig, StoreRepository storeRepository, NetworkClassLoader networkClassLoader) {
        this.request = request;
        this.errorCodeMapper = errorCodeMapper;
        this.storageEngine = AdminServiceRequestHandler.getStorageEngine(storeRepository, request.getStore());
        this.routingStrategy = metadataStore.getRoutingStrategy(this.storageEngine.getName());
        this.throttler = new EventThrottler(voldemortConfig.getStreamMaxReadBytesPerSec());
        this.partitionList = request.getPartitionsList();
        this.filter = request.hasFilter() ? AdminServiceRequestHandler.getFilterFromRequest(request.getFilter(), voldemortConfig, networkClassLoader) : (request.hasFetchMasterEntries() && request.getFetchMasterEntries() ? new MasterOnlyVoldemortFilter(this.routingStrategy, request.getPartitionsList()) : new DefaultVoldemortFilter());
        this.keyIterator = this.storageEngine.keys();
        this.startTime = System.currentTimeMillis();
    }

    public final StreamRequestHandler.StreamRequestDirection getDirection() {
        return StreamRequestHandler.StreamRequestDirection.WRITING;
    }

    public final void close(DataOutputStream outputStream) throws IOException {
        if (null != this.keyIterator) {
            this.keyIterator.close();
        }
        ProtoUtils.writeEndOfStream(outputStream);
    }

    public final void handleError(DataOutputStream outputStream, VoldemortException e) throws IOException {
        VAdminProto.FetchPartitionEntriesResponse response = VAdminProto.FetchPartitionEntriesResponse.newBuilder().setError(ProtoUtils.encodeError(this.errorCodeMapper, e)).build();
        ProtoUtils.writeMessage(outputStream, (Message)response);
        this.logger.error("handleFetchPartitionEntries failed for request(" + this.request.toString() + ")", e);
    }

    protected boolean validPartition(byte[] key) {
        List<Integer> keyPartitions = this.routingStrategy.getPartitionList(key);
        for (int p : this.partitionList) {
            if (!keyPartitions.contains(p)) continue;
            return true;
        }
        return false;
    }
}

