/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.FetchStreamRequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.utils.NetworkClassLoader;

public class FetchKeysStreamRequestHandler
extends FetchStreamRequestHandler {
    public FetchKeysStreamRequestHandler(VAdminProto.FetchPartitionEntriesRequest request, MetadataStore metadataStore, ErrorCodeMapper errorCodeMapper, VoldemortConfig voldemortConfig, StoreRepository storeRepository, NetworkClassLoader networkClassLoader) {
        super(request, metadataStore, errorCodeMapper, voldemortConfig, storeRepository, networkClassLoader);
    }

    public StreamRequestHandler.StreamRequestHandlerState handleRequest(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        if (!this.keyIterator.hasNext()) {
            return StreamRequestHandler.StreamRequestHandlerState.COMPLETE;
        }
        ByteArray key = (ByteArray)this.keyIterator.next();
        this.throttler.maybeThrottle(key.length());
        if (this.validPartition(key.get()) && this.filter.accept(key, null)) {
            VAdminProto.FetchPartitionEntriesResponse.Builder response = VAdminProto.FetchPartitionEntriesResponse.newBuilder();
            response.setKey(ProtoUtils.encodeBytes(key));
            ++this.fetched;
            VAdminProto.FetchPartitionEntriesResponse message = response.build();
            ProtoUtils.writeMessage(outputStream, (Message)message);
        }
        ++this.counter;
        if (0 == this.counter % 100000) {
            long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("fetchKeys() scanned " + this.counter + " keys, fetched " + this.fetched + " keys for store:" + this.storageEngine.getName() + " partition:" + this.partitionList + " in " + totalTime + " s");
            }
        }
        if (this.keyIterator.hasNext()) {
            return StreamRequestHandler.StreamRequestHandlerState.WRITING;
        }
        return StreamRequestHandler.StreamRequestHandlerState.COMPLETE;
    }
}

