/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.server.protocol.admin.AsyncOperationStatus;

public abstract class AsyncOperation
implements Runnable {
    protected final AsyncOperationStatus status;

    public AsyncOperation(int id, String description) {
        this.status = new AsyncOperationStatus(id, description);
    }

    @JmxGetter(name="asyncTaskStatus")
    public AsyncOperationStatus getStatus() {
        return this.status;
    }

    public void updateStatus(String msg) {
        this.status.setStatus(msg);
    }

    public void markComplete() {
        this.status.setComplete(true);
    }

    public void run() {
        this.updateStatus("started " + this.getStatus());
        try {
            this.operate();
        }
        catch (Exception e) {
            this.status.setException(e);
        }
        this.updateStatus("finished " + this.getStatus());
        this.markComplete();
    }

    public String toString() {
        return this.getStatus().toString();
    }

    public abstract void operate() throws Exception;

    @JmxOperation
    public abstract void stop();
}

