/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.admin;

import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.VoldemortFilter;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.filter.DefaultVoldemortFilter;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.routing.RoutingStrategy;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.RequestHandler;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.server.protocol.admin.AsyncOperation;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.protocol.admin.AsyncOperationStatus;
import voldemort.server.protocol.admin.FetchEntriesStreamRequestHandler;
import voldemort.server.protocol.admin.FetchKeysStreamRequestHandler;
import voldemort.server.protocol.admin.UpdatePartitionEntriesStreamRequestHandler;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.storage.StorageService;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreOperationFailureException;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteBufferBackedInputStream;
import voldemort.utils.ByteUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.NetworkClassLoader;
import voldemort.utils.Pair;
import voldemort.utils.RebalanceUtils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServiceRequestHandler
implements RequestHandler {
    private static final Logger logger = Logger.getLogger(AdminServiceRequestHandler.class);
    private static final Object lock = new Object();
    private final ErrorCodeMapper errorCodeMapper;
    private final MetadataStore metadataStore;
    private final StorageService storageService;
    private final StoreRepository storeRepository;
    private final NetworkClassLoader networkClassLoader;
    private final VoldemortConfig voldemortConfig;
    private final AsyncOperationService asyncService;
    private final Rebalancer rebalancer;

    public AdminServiceRequestHandler(ErrorCodeMapper errorCodeMapper, StorageService storageService, StoreRepository storeRepository, MetadataStore metadataStore, VoldemortConfig voldemortConfig, AsyncOperationService asyncService, Rebalancer rebalancer) {
        this.errorCodeMapper = errorCodeMapper;
        this.storageService = storageService;
        this.metadataStore = metadataStore;
        this.storeRepository = storeRepository;
        this.voldemortConfig = voldemortConfig;
        this.networkClassLoader = new NetworkClassLoader(Thread.currentThread().getContextClassLoader());
        this.asyncService = asyncService;
        this.rebalancer = rebalancer;
    }

    @Override
    public StreamRequestHandler handleRequest(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        VAdminProto.VoldemortAdminRequest.Builder request = VAdminProto.VoldemortAdminRequest.newBuilder();
        int size = inputStream.readInt();
        if (logger.isTraceEnabled()) {
            logger.trace("In handleRequest, request specified size of " + size + " bytes");
        }
        if (size < 0) {
            throw new IOException("In handleRequest, request specified size of " + size + " bytes");
        }
        byte[] input = new byte[size];
        ByteUtils.read(inputStream, input);
        request.mergeFrom(input);
        switch (request.getType()) {
            case GET_METADATA: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleGetMetadata(request.getGetMetadata()));
                break;
            }
            case UPDATE_METADATA: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleUpdateMetadata(request.getUpdateMetadata()));
                break;
            }
            case DELETE_PARTITION_ENTRIES: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleDeletePartitionEntries(request.getDeletePartitionEntries()));
                break;
            }
            case FETCH_PARTITION_ENTRIES: {
                return this.handleFetchPartitionEntries(request.getFetchPartitionEntries());
            }
            case UPDATE_PARTITION_ENTRIES: {
                return this.handleUpdatePartitionEntries(request.getUpdatePartitionEntries());
            }
            case INITIATE_FETCH_AND_UPDATE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleFetchAndUpdate(request.getInitiateFetchAndUpdate()));
                break;
            }
            case ASYNC_OPERATION_STATUS: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAsyncStatus(request.getAsyncOperationStatus()));
                break;
            }
            case INITIATE_REBALANCE_NODE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleRebalanceNode(request.getInitiateRebalanceNode()));
                break;
            }
            case ASYNC_OPERATION_LIST: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAsyncOperationList(request.getAsyncOperationList()));
                break;
            }
            case ASYNC_OPERATION_STOP: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAsyncOperationStop(request.getAsyncOperationStop()));
                break;
            }
            case TRUNCATE_ENTRIES: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleTruncateEntries(request.getTruncateEntries()));
                break;
            }
            case ADD_STORE: {
                ProtoUtils.writeMessage(outputStream, (Message)this.handleAddStore(request.getAddStore()));
                break;
            }
            default: {
                throw new VoldemortException("Unkown operation " + (Object)((Object)request.getType()));
            }
        }
        return null;
    }

    public StreamRequestHandler handleFetchPartitionEntries(VAdminProto.FetchPartitionEntriesRequest request) {
        boolean fetchValues;
        boolean bl = fetchValues = request.hasFetchValues() && request.getFetchValues();
        if (fetchValues) {
            return new FetchEntriesStreamRequestHandler(request, this.metadataStore, this.errorCodeMapper, this.voldemortConfig, this.storeRepository, this.networkClassLoader);
        }
        return new FetchKeysStreamRequestHandler(request, this.metadataStore, this.errorCodeMapper, this.voldemortConfig, this.storeRepository, this.networkClassLoader);
    }

    public StreamRequestHandler handleUpdatePartitionEntries(VAdminProto.UpdatePartitionEntriesRequest request) {
        return new UpdatePartitionEntriesStreamRequestHandler(request, this.errorCodeMapper, this.voldemortConfig, this.storeRepository, this.networkClassLoader);
    }

    public VAdminProto.AsyncOperationStatusResponse handleRebalanceNode(VAdminProto.InitiateRebalanceNodeRequest request) {
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder();
        try {
            if (!this.voldemortConfig.isEnableRebalanceService()) {
                throw new VoldemortException("Rebalance service is not enabled for node:" + this.metadataStore.getNodeId());
            }
            RebalancePartitionsInfo rebalanceStealInfo = new RebalancePartitionsInfo(request.getStealerId(), request.getDonorId(), request.getPartitionsList(), request.getDeletePartitionsList(), request.getUnbalancedStoreList(), request.getAttempt());
            int requestId = this.rebalancer.rebalanceLocalNode(rebalanceStealInfo);
            response.setRequestId(requestId).setDescription(rebalanceStealInfo.toString()).setStatus("started").setComplete(false);
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleRebalanceNode failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationListResponse handleAsyncOperationList(VAdminProto.AsyncOperationListRequest request) {
        VAdminProto.AsyncOperationListResponse.Builder response = VAdminProto.AsyncOperationListResponse.newBuilder();
        boolean showComplete = request.hasShowComplete() && request.getShowComplete();
        try {
            response.addAllRequestIds(this.asyncService.getAsyncOperationList(showComplete));
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleAsyncOperationList failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStopResponse handleAsyncOperationStop(VAdminProto.AsyncOperationStopRequest request) {
        VAdminProto.AsyncOperationStopResponse.Builder response = VAdminProto.AsyncOperationStopResponse.newBuilder();
        int requestId = request.getRequestId();
        try {
            this.asyncService.stopOperation(requestId);
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleAsyncOperationStop failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStatusResponse handleFetchAndUpdate(VAdminProto.InitiateFetchAndUpdateRequest request) {
        final int nodeId = request.getNodeId();
        final List<Integer> partitions = request.getPartitionsList();
        final DefaultVoldemortFilter filter = request.hasFilter() ? AdminServiceRequestHandler.getFilterFromRequest(request.getFilter(), this.voldemortConfig, this.networkClassLoader) : new DefaultVoldemortFilter();
        final String storeName = request.getStore();
        int requestId = this.asyncService.getUniqueRequestId();
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder().setRequestId(requestId).setComplete(false).setDescription("Fetch and update").setStatus("started");
        try {
            this.asyncService.submitOperation(requestId, new AsyncOperation(requestId, "Fetch and Update"){
                private final AtomicBoolean running;
                {
                    super(x0, x1);
                    this.running = new AtomicBoolean(true);
                }

                public void stop() {
                    this.running.set(false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operate() {
                    AdminClient adminClient = RebalanceUtils.createTempAdminClient(AdminServiceRequestHandler.this.voldemortConfig, AdminServiceRequestHandler.this.metadataStore.getCluster(), 4, 2);
                    try {
                        StorageEngine<ByteArray, byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(AdminServiceRequestHandler.this.storeRepository, storeName);
                        Iterator<Pair<ByteArray, Versioned<byte[]>>> entriesIterator = adminClient.fetchEntries(nodeId, storeName, partitions, filter, false);
                        this.updateStatus("Initated fetchPartitionEntries");
                        EventThrottler throttler = new EventThrottler(AdminServiceRequestHandler.this.voldemortConfig.getStreamMaxWriteBytesPerSec());
                        long i = 0L;
                        while (this.running.get() && entriesIterator.hasNext()) {
                            Pair<ByteArray, Versioned<byte[]>> entry = entriesIterator.next();
                            ByteArray key = entry.getFirst();
                            Versioned<byte[]> value = entry.getSecond();
                            try {
                                storageEngine.put(key, value);
                            }
                            catch (ObsoleteVersionException e) {
                                logger.debug("migratePartition threw ObsoleteVersionException, Ignoring.");
                            }
                            throttler.maybeThrottle(key.length() + AdminServiceRequestHandler.valueSize(value));
                            if (i % 1000L == 0L) {
                                this.updateStatus(i + " entries processed");
                            }
                            ++i;
                        }
                    }
                    finally {
                        adminClient.stop();
                    }
                }
            });
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleFetchAndUpdate failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    public VAdminProto.AsyncOperationStatusResponse handleAsyncStatus(VAdminProto.AsyncOperationStatusRequest request) {
        VAdminProto.AsyncOperationStatusResponse.Builder response = VAdminProto.AsyncOperationStatusResponse.newBuilder();
        try {
            int requestId = request.getRequestId();
            AsyncOperationStatus operationStatus = this.asyncService.getOperationStatus(requestId);
            boolean requestComplete = this.asyncService.isComplete(requestId);
            response.setDescription(operationStatus.getDescription());
            response.setComplete(requestComplete);
            response.setStatus(operationStatus.getStatus());
            response.setRequestId(requestId);
            if (operationStatus.hasException()) {
                throw new VoldemortException(operationStatus.getException());
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleAsyncStatus failed for request(" + request.toString().trim() + ")", e);
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.DeletePartitionEntriesResponse handleDeletePartitionEntries(VAdminProto.DeletePartitionEntriesRequest request) {
        VAdminProto.DeletePartitionEntriesResponse.Builder response = VAdminProto.DeletePartitionEntriesResponse.newBuilder();
        ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator = null;
        try {
            String storeName = request.getStore();
            List<Integer> partitions = request.getPartitionsList();
            StorageEngine<ByteArray, byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(this.storeRepository, storeName);
            DefaultVoldemortFilter filter = request.hasFilter() ? AdminServiceRequestHandler.getFilterFromRequest(request.getFilter(), this.voldemortConfig, this.networkClassLoader) : new DefaultVoldemortFilter();
            RoutingStrategy routingStrategy = this.metadataStore.getRoutingStrategy(storageEngine.getName());
            EventThrottler throttler = new EventThrottler(this.voldemortConfig.getStreamMaxReadBytesPerSec());
            iterator = storageEngine.entries();
            int deleteSuccess = 0;
            while (iterator.hasNext()) {
                Pair entry = (Pair)iterator.next();
                ByteArray key = (ByteArray)entry.getFirst();
                Versioned value = (Versioned)entry.getSecond();
                throttler.maybeThrottle(key.length() + AdminServiceRequestHandler.valueSize(value));
                if (!this.checkKeyBelongsToDeletePartition(key.get(), partitions, routingStrategy) || !filter.accept(key, value) || !storageEngine.delete(key, value.getVersion())) continue;
                ++deleteSuccess;
            }
            response.setCount(deleteSuccess);
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleDeletePartitionEntries failed for request(" + request.toString() + ")", e);
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return response.build();
    }

    public VAdminProto.UpdateMetadataResponse handleUpdateMetadata(VAdminProto.UpdateMetadataRequest request) {
        VAdminProto.UpdateMetadataResponse.Builder response = VAdminProto.UpdateMetadataResponse.newBuilder();
        try {
            ByteArray key = ProtoUtils.decodeBytes(request.getKey());
            String keyString = ByteUtils.getString(key.get(), "UTF-8");
            if (MetadataStore.METADATA_KEYS.contains(keyString)) {
                Versioned<byte[]> versionedValue = ProtoUtils.decodeVersioned(request.getVersioned());
                this.metadataStore.put(new ByteArray(ByteUtils.getBytes(keyString, "UTF-8")), versionedValue);
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleUpdateMetadata failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    public VAdminProto.GetMetadataResponse handleGetMetadata(VAdminProto.GetMetadataRequest request) {
        VAdminProto.GetMetadataResponse.Builder response;
        block4: {
            response = VAdminProto.GetMetadataResponse.newBuilder();
            try {
                ByteArray key = ProtoUtils.decodeBytes(request.getKey());
                String keyString = ByteUtils.getString(key.get(), "UTF-8");
                if (MetadataStore.METADATA_KEYS.contains(keyString)) {
                    int size;
                    List<Versioned<byte[]>> versionedList = this.metadataStore.get(key);
                    int n = size = versionedList.size() > 0 ? 1 : 0;
                    if (size > 0) {
                        Versioned<byte[]> versioned = versionedList.get(0);
                        response.setVersion(ProtoUtils.encodeVersioned(versioned));
                    }
                    break block4;
                }
                throw new VoldemortException("Metadata Key passed " + keyString + " is not handled yet ...");
            }
            catch (VoldemortException e) {
                response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
                logger.error("handleGetMetadata failed for request(" + request.toString() + ")", e);
            }
        }
        return response.build();
    }

    public VAdminProto.TruncateEntriesResponse handleTruncateEntries(VAdminProto.TruncateEntriesRequest request) {
        VAdminProto.TruncateEntriesResponse.Builder response = VAdminProto.TruncateEntriesResponse.newBuilder();
        try {
            String storeName = request.getStore();
            StorageEngine<ByteArray, byte[]> storageEngine = AdminServiceRequestHandler.getStorageEngine(this.storeRepository, storeName);
            storageEngine.truncate();
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleTruncateEntries failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VAdminProto.AddStoreResponse handleAddStore(VAdminProto.AddStoreRequest request) {
        VAdminProto.AddStoreResponse.Builder response = VAdminProto.AddStoreResponse.newBuilder();
        if (this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER) || this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.REBALANCING_CLUSTER)) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, new VoldemortException("Rebalancing in progress")));
            return response.build();
        }
        try {
            StoreDefinitionsMapper mapper = new StoreDefinitionsMapper();
            StoreDefinition def = mapper.readStore(new StringReader(request.getStoreDefinition()));
            Object object = lock;
            synchronized (object) {
                List<StoreDefinition> currentStoreDefs;
                if (!this.storeRepository.hasLocalStore(def.getName())) {
                    this.storageService.openStore(def);
                    List<Versioned<byte[]>> v = this.metadataStore.get("stores.xml");
                    if ((v.size() > 0 ? 1 : 0) > 0) {
                        Versioned<byte[]> currentValue = v.get(0);
                        currentStoreDefs = mapper.readStoreList(new StringReader(ByteUtils.getString(currentValue.getValue(), "UTF-8")));
                    } else {
                        currentStoreDefs = Lists.newArrayList();
                    }
                } else {
                    throw new StoreOperationFailureException(String.format("Store '%s' already exists on this server", def.getName()));
                }
                currentStoreDefs.add(def);
                this.metadataStore.put("stores.xml", currentStoreDefs);
            }
        }
        catch (VoldemortException e) {
            response.setError(ProtoUtils.encodeError(this.errorCodeMapper, e));
            logger.error("handleAddStore failed for request(" + request.toString() + ")", e);
        }
        return response.build();
    }

    @Override
    public boolean isCompleteRequest(ByteBuffer buffer) {
        DataInputStream inputStream = new DataInputStream(new ByteBufferBackedInputStream(buffer));
        try {
            int dataSize = inputStream.readInt();
            if (logger.isTraceEnabled()) {
                logger.trace("In isCompleteRequest, dataSize: " + dataSize + ", buffer position: " + buffer.position());
            }
            if (dataSize == -1) {
                return true;
            }
            buffer.position(buffer.position() + dataSize);
            return true;
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("In isCompleteRequest, probable partial read occurred: " + e);
            }
            return false;
        }
    }

    static VoldemortFilter getFilterFromRequest(VAdminProto.VoldemortFilter request, VoldemortConfig voldemortConfig, NetworkClassLoader networkClassLoader) {
        VoldemortFilter filter = null;
        byte[] classBytes = ProtoUtils.decodeBytes(request.getData()).get();
        String className = request.getName();
        logger.debug("Attempt to load VoldemortFilter class:" + className);
        try {
            if (voldemortConfig.isNetworkClassLoaderEnabled()) {
                logger.warn("NetworkLoader is experimental and should not be used for now.");
                Class<?> cl = networkClassLoader.loadClass(className, classBytes, 0, classBytes.length);
                filter = (VoldemortFilter)cl.newInstance();
            } else {
                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
                filter = (VoldemortFilter)cl.newInstance();
            }
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to load and instantiate the filter class", e);
        }
        return filter;
    }

    static int valueSize(Versioned<byte[]> value) {
        return value.getValue().length + ((VectorClock)value.getVersion()).sizeInBytes() + 1;
    }

    static StorageEngine<ByteArray, byte[]> getStorageEngine(StoreRepository storeRepository, String storeName) {
        StorageEngine<ByteArray, byte[]> storageEngine = storeRepository.getStorageEngine(storeName);
        if (storageEngine == null) {
            throw new VoldemortException("No store named '" + storeName + "'.");
        }
        return storageEngine;
    }

    protected boolean checkKeyBelongsToDeletePartition(byte[] key, List<Integer> partitionList, RoutingStrategy routingStrategy) {
        List<Integer> keyPartitions = routingStrategy.getPartitionList(key);
        ArrayList<Integer> ownedPartitions = new ArrayList<Integer>(this.metadataStore.getCluster().getNodeById(this.metadataStore.getNodeId()).getPartitionIds());
        ownedPartitions.removeAll(partitionList);
        for (int p : keyPartitions) {
            if (ownedPartitions.contains(p)) {
                return false;
            }
            if (!partitionList.contains(p)) continue;
            return true;
        }
        return false;
    }
}

