/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol;

import voldemort.VoldemortException;
import voldemort.server.RequestRoutingType;
import voldemort.server.StoreRepository;
import voldemort.server.protocol.RequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.Store;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestHandler
implements RequestHandler {
    private final ErrorCodeMapper errorMapper;
    private final StoreRepository storeRepository;

    protected AbstractRequestHandler(ErrorCodeMapper errorMapper, StoreRepository repository) {
        this.errorMapper = errorMapper;
        this.storeRepository = repository;
    }

    protected ErrorCodeMapper getErrorMapper() {
        return this.errorMapper;
    }

    protected StoreRepository getStoreRepository() {
        return this.storeRepository;
    }

    protected Store<ByteArray, byte[]> getStore(String name, RequestRoutingType type) {
        switch (type) {
            case ROUTED: {
                return this.storeRepository.getRoutedStore(name);
            }
            case NORMAL: {
                return this.storeRepository.getLocalStore(name);
            }
            case IGNORE_CHECKS: {
                return this.storeRepository.getStorageEngine(name);
            }
        }
        throw new VoldemortException("Unhandled RoutingType found:" + (Object)((Object)type));
    }
}

