/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.niosocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import voldemort.server.niosocket.AsyncRequestHandler;
import voldemort.server.protocol.RequestHandlerFactory;

public class SelectorManager
implements Runnable {
    private final InetSocketAddress endpoint;
    private final Selector selector;
    private final Queue<SocketChannel> socketChannelQueue;
    private final RequestHandlerFactory requestHandlerFactory;
    private final int socketBufferSize;
    private final AtomicBoolean isClosed;
    private final Logger logger = Logger.getLogger(this.getClass());

    public SelectorManager(InetSocketAddress endpoint, RequestHandlerFactory requestHandlerFactory, int socketBufferSize) throws IOException {
        this.endpoint = endpoint;
        this.selector = Selector.open();
        this.socketChannelQueue = new ConcurrentLinkedQueue<SocketChannel>();
        this.requestHandlerFactory = requestHandlerFactory;
        this.socketBufferSize = socketBufferSize;
        this.isClosed = new AtomicBoolean(false);
    }

    public void accept(SocketChannel socketChannel) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Cannot accept more channels, selector manager closed");
        }
        this.socketChannelQueue.add(socketChannel);
        this.selector.wakeup();
    }

    public void close() {
        block14: {
            block13: {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                try {
                    for (SelectionKey sk : this.selector.keys()) {
                        block12: {
                            try {
                                if (this.logger.isTraceEnabled()) {
                                    this.logger.trace("Closing SelectionKey's channel " + sk + " for " + this.endpoint);
                                }
                                sk.channel().close();
                            }
                            catch (Exception e) {
                                if (!this.logger.isEnabledFor(Level.WARN)) break block12;
                                this.logger.warn(e.getMessage(), e);
                            }
                        }
                        try {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Cancelling SelectionKey " + sk + " for " + this.endpoint);
                            }
                            sk.cancel();
                        }
                        catch (Exception e) {
                            if (!this.logger.isEnabledFor(Level.WARN)) continue;
                            this.logger.warn(e.getMessage(), e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor(Level.WARN)) break block13;
                    this.logger.warn(e.getMessage(), e);
                }
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor(Level.WARN)) break block14;
                this.logger.warn(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block14: while (true) {
                if (this.isClosed.get()) {
                    if (!this.logger.isInfoEnabled()) return;
                    this.logger.info("Closed, exiting for " + this.endpoint);
                    return;
                }
                this.processSockets();
                try {
                    int selected = this.selector.select();
                    if (this.isClosed.get()) {
                        if (!this.logger.isInfoEnabled()) return;
                        this.logger.info("Closed, exiting for " + this.endpoint);
                        return;
                    }
                    if (selected <= 0) continue;
                    Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!i.hasNext()) continue block14;
                        SelectionKey selectionKey = i.next();
                        i.remove();
                        if (!selectionKey.isReadable() && !selectionKey.isWritable()) continue;
                        Runnable worker = (Runnable)selectionKey.attachment();
                        worker.run();
                    }
                }
                catch (ClosedSelectorException e) {
                    if (!this.logger.isDebugEnabled()) return;
                    this.logger.debug("Selector is closed, exiting for " + this.endpoint);
                    return;
                }
                catch (Throwable t) {
                    if (!this.logger.isEnabledFor(Level.ERROR)) continue;
                    this.logger.error(t.getMessage(), t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            if (!this.logger.isEnabledFor(Level.ERROR)) return;
            this.logger.error(t.getMessage(), t);
            return;
        }
        finally {
            block18: {
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor(Level.ERROR)) break block18;
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private void processSockets() {
        block12: {
            try {
                SocketChannel socketChannel = null;
                while ((socketChannel = this.socketChannelQueue.poll()) != null) {
                    if (this.isClosed.get()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.debug("Closed, exiting for " + this.endpoint);
                        }
                        break;
                    }
                    try {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Registering connection from " + socketChannel.socket().getPort());
                        }
                        socketChannel.socket().setTcpNoDelay(true);
                        socketChannel.socket().setReuseAddress(true);
                        socketChannel.socket().setSendBufferSize(this.socketBufferSize);
                        if (socketChannel.socket().getReceiveBufferSize() != this.socketBufferSize && this.logger.isDebugEnabled()) {
                            this.logger.debug("Requested socket receive buffer size was " + this.socketBufferSize + " bytes but actual size is " + socketChannel.socket().getReceiveBufferSize() + " bytes.");
                        }
                        if (socketChannel.socket().getSendBufferSize() != this.socketBufferSize && this.logger.isDebugEnabled()) {
                            this.logger.debug("Requested socket send buffer size was " + this.socketBufferSize + " bytes but actual size is " + socketChannel.socket().getSendBufferSize() + " bytes.");
                        }
                        socketChannel.configureBlocking(false);
                        AsyncRequestHandler attachment = new AsyncRequestHandler(this.selector, socketChannel, this.requestHandlerFactory, this.socketBufferSize);
                        if (this.isClosed.get()) continue;
                        socketChannel.register(this.selector, 1, attachment);
                    }
                    catch (ClosedSelectorException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Selector is closed, exiting");
                        }
                        this.close();
                        break;
                    }
                    catch (Exception e) {
                        if (!this.logger.isEnabledFor(Level.ERROR)) continue;
                        this.logger.error(e.getMessage(), e);
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor(Level.ERROR)) break block12;
                this.logger.error(e.getMessage(), e);
            }
        }
    }
}

