/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.niosocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.server.AbstractSocketService;
import voldemort.server.ServiceType;
import voldemort.server.StatusManager;
import voldemort.server.niosocket.SelectorManager;
import voldemort.server.protocol.RequestHandlerFactory;
import voldemort.utils.DaemonThreadFactory;

public class NioSocketService
extends AbstractSocketService {
    private static final int SHUTDOWN_TIMEOUT_MS = 15000;
    private final RequestHandlerFactory requestHandlerFactory;
    private final ServerSocketChannel serverSocketChannel;
    private final InetSocketAddress endpoint;
    private final SelectorManager[] selectorManagers;
    private final ExecutorService selectorManagerThreadPool;
    private final int socketBufferSize;
    private final StatusManager statusManager;
    private final Thread acceptorThread;
    private final Logger logger = Logger.getLogger(this.getClass());

    public NioSocketService(RequestHandlerFactory requestHandlerFactory, int port, int socketBufferSize, int selectors, String serviceName, boolean enableJmx) {
        super(ServiceType.SOCKET, port, serviceName, enableJmx);
        this.requestHandlerFactory = requestHandlerFactory;
        this.socketBufferSize = socketBufferSize;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        this.endpoint = new InetSocketAddress(port);
        this.selectorManagers = new SelectorManager[selectors];
        this.selectorManagerThreadPool = Executors.newFixedThreadPool(this.selectorManagers.length, new DaemonThreadFactory("voldemort-niosocket-server"));
        this.statusManager = new StatusManager((ThreadPoolExecutor)this.selectorManagerThreadPool);
        this.acceptorThread = new Thread(new Acceptor());
    }

    public StatusManager getStatusManager() {
        return this.statusManager;
    }

    protected void startInner() {
        if (this.logger.isEnabledFor(Level.INFO)) {
            this.logger.info("Starting Voldemort NIO socket server (" + this.serviceName + ") on port " + this.port);
        }
        try {
            for (int i = 0; i < this.selectorManagers.length; ++i) {
                this.selectorManagers[i] = new SelectorManager(this.endpoint, this.requestHandlerFactory, this.socketBufferSize);
                this.selectorManagerThreadPool.execute(this.selectorManagers[i]);
            }
            this.serverSocketChannel.socket().bind(this.endpoint);
            this.serverSocketChannel.socket().setReceiveBufferSize(this.socketBufferSize);
            this.serverSocketChannel.socket().setReuseAddress(true);
            this.acceptorThread.start();
        }
        catch (Exception e) {
            throw new VoldemortException(e);
        }
        this.enableJmx(this);
    }

    protected void stopInner() {
        block19: {
            block18: {
                block17: {
                    block16: {
                        if (this.logger.isEnabledFor(Level.INFO)) {
                            this.logger.info("Stopping Voldemort NIO socket server (" + this.serviceName + ") on port " + this.port);
                        }
                        try {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Interrupted acceptor thread, waiting 15000 ms for termination");
                            }
                            this.acceptorThread.interrupt();
                            this.acceptorThread.join(15000L);
                            if (this.acceptorThread.isAlive() && this.logger.isEnabledFor(Level.WARN)) {
                                this.logger.warn("Acceptor thread pool did not stop cleanly after 15000 ms");
                            }
                        }
                        catch (Exception e) {
                            if (!this.logger.isEnabledFor(Level.WARN)) break block16;
                            this.logger.warn(e.getMessage(), e);
                        }
                    }
                    try {
                        boolean terminated;
                        for (int i = 0; i < this.selectorManagers.length; ++i) {
                            try {
                                this.selectorManagers[i].close();
                                continue;
                            }
                            catch (Exception e) {
                                if (!this.logger.isEnabledFor(Level.WARN)) continue;
                                this.logger.warn(e.getMessage(), e);
                            }
                        }
                        this.selectorManagerThreadPool.shutdown();
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Shut down SelectorManager thread pool acceptor, waiting 15000 ms for termination");
                        }
                        if (!(terminated = this.selectorManagerThreadPool.awaitTermination(15000L, TimeUnit.MILLISECONDS)) && this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn("SelectorManager thread pool did not stop cleanly after 15000 ms");
                        }
                    }
                    catch (Exception e) {
                        if (!this.logger.isEnabledFor(Level.WARN)) break block17;
                        this.logger.warn(e.getMessage(), e);
                    }
                }
                try {
                    this.serverSocketChannel.socket().close();
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor(Level.WARN)) break block18;
                    this.logger.warn(e.getMessage(), e);
                }
            }
            try {
                this.serverSocketChannel.close();
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor(Level.WARN)) break block19;
                this.logger.warn(e.getMessage(), e);
            }
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        public void run() {
            if (NioSocketService.this.logger.isInfoEnabled()) {
                NioSocketService.this.logger.info("Server now listening for connections on port " + NioSocketService.this.port);
            }
            AtomicInteger counter = new AtomicInteger();
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    if (!NioSocketService.this.logger.isInfoEnabled()) break;
                    NioSocketService.this.logger.info("Acceptor thread interrupted");
                    break;
                }
                try {
                    SocketChannel socketChannel = NioSocketService.this.serverSocketChannel.accept();
                    if (socketChannel == null) {
                        if (!NioSocketService.this.logger.isEnabledFor(Level.WARN)) continue;
                        NioSocketService.this.logger.warn("Claimed accept but nothing to select");
                        continue;
                    }
                    SelectorManager selectorManager = NioSocketService.this.selectorManagers[counter.getAndIncrement() % NioSocketService.this.selectorManagers.length];
                    selectorManager.accept(socketChannel);
                    continue;
                }
                catch (ClosedByInterruptException e) {
                    if (!NioSocketService.this.logger.isTraceEnabled()) break;
                    NioSocketService.this.logger.trace("Acceptor thread interrupted, closing");
                }
                catch (Exception e) {
                    if (!NioSocketService.this.logger.isEnabledFor(Level.WARN)) continue;
                    NioSocketService.this.logger.warn(e.getMessage(), e);
                    continue;
                }
                break;
            }
            if (NioSocketService.this.logger.isInfoEnabled()) {
                NioSocketService.this.logger.info("Server has stopped listening for connections on port " + NioSocketService.this.port);
            }
        }
    }
}

