/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http.gui;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import voldemort.VoldemortException;
import voldemort.server.AbstractSocketService;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortServer;
import voldemort.server.http.gui.VelocityEngine;
import voldemort.store.Store;
import voldemort.store.stats.RequestCounter;
import voldemort.store.stats.StatTrackingStore;
import voldemort.store.stats.Tracked;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;

public class StatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private VoldemortServer server;
    private VelocityEngine velocityEngine;
    private AbstractSocketService abstractSocketService;
    private String myMachine;

    public StatusServlet(VoldemortServer server, VelocityEngine engine) {
        this.server = Utils.notNull(server);
        this.velocityEngine = Utils.notNull(engine);
        this.abstractSocketService = (AbstractSocketService)server.getService(ServiceType.SOCKET);
        try {
            this.myMachine = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.myMachine = "unknown";
        }
    }

    public void init() throws ServletException {
        super.init();
        this.server = (VoldemortServer)Utils.notNull(this.getServletContext().getAttribute("vldmt_server"));
        this.velocityEngine = (VelocityEngine)Utils.notNull(this.getServletContext().getAttribute("vldmt_velocity_engine"));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format;
        Store<ByteArray, byte[]> store;
        String storeName = request.getParameter("store");
        if ("reset".equals(request.getParameter("action")) && storeName != null && (store = this.server.getStoreRepository().getLocalStore(storeName)) != null && store instanceof StatTrackingStore) {
            ((StatTrackingStore)store).resetStatistics();
        }
        if ("json".equals(format = request.getParameter("format"))) {
            this.outputJSON(response);
            return;
        }
        response.setContentType("text/html");
        long refreshTime = 600L;
        String refresh = request.getParameter("refresh");
        if (refresh != null) {
            try {
                refreshTime = Integer.parseInt(refresh);
            }
            catch (NumberFormatException e) {
                response.sendError(400);
            }
        }
        List<Store<ByteArray, byte[]>> stores = null;
        stores = storeName == null ? this.server.getStoreRepository().getAllLocalStores() : Collections.singletonList(this.server.getStoreRepository().getLocalStore(storeName));
        HashMap<String, Object> params = Maps.newHashMap();
        params.put("status", this.abstractSocketService.getStatusManager());
        params.put("counters", Tracked.values());
        params.put("stores", stores);
        params.put("refresh", refreshTime);
        this.velocityEngine.render("status.vm", params, (OutputStream)response.getOutputStream());
    }

    protected void outputJSON(HttpServletResponse response) {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append("  \"servertime\": \"");
        sb.append(new Date());
        sb.append("\",");
        sb.append("\n  \"server\": \"");
        sb.append(this.myMachine);
        sb.append("\",");
        sb.append("\n  \"node\": \"");
        sb.append(this.server.getMetadataStore().getNodeId());
        sb.append("\",");
        sb.append("\n  \"uptime\": \"");
        sb.append(this.abstractSocketService.getStatusManager().getFormattedUptime());
        sb.append("\",");
        sb.append("\n  \"num_workers\": ");
        sb.append(this.abstractSocketService.getStatusManager().getActiveWorkersCount());
        sb.append(",");
        sb.append("\n  \"pool_size\": ");
        sb.append(this.abstractSocketService.getStatusManager().getWorkerPoolSize());
        sb.append(",");
        sb.append("\n  \"stores\": {");
        int i = 0;
        for (Store<ByteArray, byte[]> store : this.server.getStoreRepository().getAllLocalStores()) {
            if (!(store instanceof StatTrackingStore)) continue;
            StatTrackingStore statStore = (StatTrackingStore)store;
            Map<Tracked, RequestCounter> stats = statStore.getStats().getCounters();
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append("\n    \"");
            sb.append(statStore.getName());
            sb.append("\" : {\n");
            int j = 0;
            for (Tracked t : Tracked.values()) {
                if (t == Tracked.EXCEPTION) continue;
                if (j++ > 0) {
                    sb.append(",\n");
                }
                sb.append("        \"");
                sb.append(t.toString());
                sb.append("\": { ");
                sb.append("\"total\": ");
                sb.append(stats.get((Object)t).getTotalCount());
                sb.append(", ");
                sb.append("\"operations\": ");
                sb.append(stats.get((Object)t).getCount());
                sb.append(", ");
                sb.append("\"throughput\": ");
                sb.append(stats.get((Object)t).getDisplayThroughput());
                sb.append(", ");
                sb.append("\"avg_time_ms\": ");
                sb.append(stats.get((Object)t).getDisplayAverageTimeInMs());
                sb.append(" }");
            }
            sb.append(",\n        \"num_exceptions\": ");
            sb.append(statStore.getStats().getCount(Tracked.EXCEPTION));
            sb.append("\n");
            sb.append("    }");
        }
        sb.append("\n  }\n");
        sb.append("}\n");
        try {
            response.setContentType("text/plain");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream());
            writer.write(sb.toString());
            writer.flush();
        }
        catch (Exception e) {
            throw new VoldemortException(e);
        }
    }
}

