/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortServer;
import voldemort.server.http.gui.VelocityEngine;
import voldemort.server.storage.StorageService;
import voldemort.store.StorageEngine;
import voldemort.store.readonly.FileFetcher;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.Props;
import voldemort.utils.ReflectUtils;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStoreManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ReadOnlyStoreManagementServlet.class);
    private List<ReadOnlyStorageEngine> stores;
    private VelocityEngine velocityEngine;
    private FileFetcher fileFetcher;

    public ReadOnlyStoreManagementServlet() {
    }

    public ReadOnlyStoreManagementServlet(VoldemortServer server, VelocityEngine engine) {
        this.stores = this.getReadOnlyStores(server);
        this.velocityEngine = Utils.notNull(engine);
        this.setFetcherClass(server);
    }

    public void init() throws ServletException {
        super.init();
        VoldemortServer server = (VoldemortServer)this.getServletContext().getAttribute("vldmt_server");
        this.stores = this.getReadOnlyStores(server);
        this.velocityEngine = (VelocityEngine)Utils.notNull(this.getServletContext().getAttribute("vldmt_velocity_engine"));
        this.setFetcherClass(server);
    }

    private void setFetcherClass(VoldemortServer server) {
        String className = server.getVoldemortConfig().getAllProps().getString("file.fetcher.class", null);
        if (className == null || className.trim().length() == 0) {
            this.fileFetcher = null;
        } else {
            try {
                logger.info("Loading fetcher " + className);
                Class<?> cls = Class.forName(className.trim());
                this.fileFetcher = (FileFetcher)ReflectUtils.callConstructor(cls, new Class[]{Props.class}, new Object[]{server.getVoldemortConfig().getAllProps()});
            }
            catch (Exception e) {
                throw new VoldemortException("Error loading file fetcher class " + className, e);
            }
        }
    }

    private List<ReadOnlyStorageEngine> getReadOnlyStores(VoldemortServer server) {
        StorageService storage = (StorageService)Utils.notNull(server).getService(ServiceType.STORAGE);
        ArrayList<ReadOnlyStorageEngine> l = Lists.newArrayList();
        for (StorageEngine<ByteArray, byte[]> engine : storage.getStoreRepository().getStorageEnginesByClass(ReadOnlyStorageEngine.class)) {
            l.add((ReadOnlyStorageEngine)engine);
        }
        return l;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> params = Maps.newHashMap();
        params.put("stores", this.stores);
        this.velocityEngine.render("read-only-mgmt.vm", params, (OutputStream)resp.getOutputStream());
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block5: {
            try {
                String operation = this.getRequired(req, "operation").toLowerCase();
                if ("swap".equals(operation)) {
                    this.doSwap(req, resp);
                    break block5;
                }
                if ("fetch".equals(operation)) {
                    this.doFetch(req, resp);
                    break block5;
                }
                if ("rollback".equals(operation)) {
                    this.doRollback(req);
                    break block5;
                }
                throw new IllegalArgumentException("Unknown operation parameter: " + req.getParameter("operation"));
            }
            catch (Exception e) {
                logger.error("Error while performing operation.", e);
                resp.sendError(500, "Error while performing operation: " + e.getMessage());
            }
        }
    }

    private void doSwap(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String dir = this.getRequired(req, "dir");
        String storeName = this.getRequired(req, "store");
        ReadOnlyStorageEngine store = this.getStore(storeName);
        if (store == null) {
            throw new ServletException("'" + storeName + "' is not a registered read-only store.");
        }
        if (!Utils.isReadableDir(dir)) {
            throw new ServletException("Store directory '" + dir + "' is not a readable directory.");
        }
        store.swapFiles(dir);
        resp.getWriter().write("Swap completed.");
    }

    private void doFetch(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        File fetchDir;
        String fetchUrl = this.getRequired(req, "dir");
        String storeName = this.getOptional(req, "store");
        if (this.fileFetcher == null) {
            fetchDir = new File(fetchUrl);
        } else {
            logger.info("Executing fetch of " + fetchUrl);
            fetchDir = this.fileFetcher.fetch(fetchUrl, storeName);
            if (fetchDir == null) {
                throw new ServletException("Checksum failed for " + fetchUrl + " and store name = " + storeName);
            }
            logger.info("Fetch complete.");
        }
        resp.getWriter().write(fetchDir.getAbsolutePath());
    }

    private String getOptional(HttpServletRequest req, String name) {
        String val = req.getParameter(name);
        if (val == null) {
            return "";
        }
        return val;
    }

    private void doRollback(HttpServletRequest req) throws ServletException {
        String storeName = this.getRequired(req, "store");
        ReadOnlyStorageEngine store = this.getStore(storeName);
        store.rollback();
    }

    private String getRequired(HttpServletRequest req, String name) throws ServletException {
        String val = req.getParameter(name);
        if (val == null) {
            throw new ServletException("Missing required parameter '" + name + "'.");
        }
        return val;
    }

    private ReadOnlyStorageEngine getStore(String storeName) throws ServletException {
        for (ReadOnlyStorageEngine store : this.stores) {
            if (!store.getName().equals(storeName)) continue;
            return store;
        }
        throw new ServletException("'" + storeName + "' is not a registered read-only store.");
    }
}

