/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http.gui;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import voldemort.server.VoldemortServer;
import voldemort.server.http.gui.VelocityEngine;
import voldemort.utils.Utils;

public class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private VoldemortServer server;
    private VelocityEngine velocityEngine;

    public AdminServlet() {
    }

    public AdminServlet(VoldemortServer server, VelocityEngine engine) {
        this.server = Utils.notNull(server);
        this.velocityEngine = Utils.notNull(engine);
    }

    public void init() throws ServletException {
        super.init();
        this.server = (VoldemortServer)Utils.notNull(this.getServletContext().getAttribute("vldmt_server"));
        this.velocityEngine = (VelocityEngine)Utils.notNull(this.getServletContext().getAttribute("vldmt_velocity_engine"));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, Object> params = Maps.newHashMap();
        params.put("cluster", this.server.getMetadataStore().getCluster());
        params.put("repository", this.server.getStoreRepository());
        params.put("services", this.server.getServices());
        this.velocityEngine.render("admin.vm", params, (OutputStream)response.getOutputStream());
    }
}

