/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.gossip;

import voldemort.annotations.jmx.JmxManaged;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortConfig;
import voldemort.server.gossip.Gossiper;
import voldemort.server.scheduler.SchedulerService;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;

@JmxManaged(description="Gossip protocol for synchronizing state/configuration in a cluster.")
public class GossipService
extends AbstractService {
    private final SchedulerService schedulerService;
    private final Gossiper gossiper;
    private final AdminClient adminClient;

    public GossipService(MetadataStore metadataStore, SchedulerService service, VoldemortConfig voldemortConfig) {
        super(ServiceType.GOSSIP);
        this.schedulerService = service;
        this.adminClient = RebalanceUtils.createTempAdminClient(voldemortConfig, metadataStore.getCluster(), 4, 2);
        this.gossiper = new Gossiper(metadataStore, this.adminClient, voldemortConfig.getGossipInterval());
    }

    protected void startInner() {
        this.gossiper.start();
        this.schedulerService.scheduleNow(this.gossiper);
    }

    protected void stopInner() {
        this.gossiper.stop();
        this.adminClient.stop();
    }
}

