/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.VoldemortService;
import voldemort.server.gossip.GossipService;
import voldemort.server.http.HttpService;
import voldemort.server.jmx.JmxService;
import voldemort.server.niosocket.NioSocketService;
import voldemort.server.protocol.SocketRequestHandlerFactory;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.rebalance.RebalancerService;
import voldemort.server.scheduler.SchedulerService;
import voldemort.server.socket.SocketService;
import voldemort.server.storage.StorageService;
import voldemort.store.configuration.ConfigurationStorageEngine;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.SystemTime;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortServer
extends AbstractService {
    private static final Logger logger = Logger.getLogger(VoldemortServer.class.getName());
    public static final long DEFAULT_PUSHER_POLL_MS = 60000L;
    private static final int ASYNC_REQUEST_CACHE_SIZE = 64;
    private final Node identityNode;
    private final List<VoldemortService> services;
    private final StoreRepository storeRepository;
    private final VoldemortConfig voldemortConfig;
    private final MetadataStore metadata;
    private AsyncOperationService asyncService;

    public VoldemortServer(VoldemortConfig config) {
        super(ServiceType.VOLDEMORT);
        this.voldemortConfig = config;
        this.storeRepository = new StoreRepository();
        this.metadata = MetadataStore.readFromDirectory(new File(this.voldemortConfig.getMetadataDirectory()), this.voldemortConfig.getNodeId());
        this.identityNode = this.metadata.getCluster().getNodeById(this.voldemortConfig.getNodeId());
        this.services = this.createServices();
    }

    public VoldemortServer(VoldemortConfig config, Cluster cluster) {
        super(ServiceType.VOLDEMORT);
        this.voldemortConfig = config;
        this.identityNode = cluster.getNodeById(this.voldemortConfig.getNodeId());
        this.storeRepository = new StoreRepository();
        ConfigurationStorageEngine metadataInnerEngine = new ConfigurationStorageEngine("metadata-config-store", this.voldemortConfig.getMetadataDirectory());
        metadataInnerEngine.put("cluster.xml", new Versioned<String>(new ClusterMapper().writeCluster(cluster)));
        this.metadata = new MetadataStore(metadataInnerEngine, this.voldemortConfig.getNodeId());
        this.services = this.createServices();
    }

    public AsyncOperationService getAsyncRunner() {
        return this.asyncService;
    }

    private List<VoldemortService> createServices() {
        ArrayList<VoldemortService> services = new ArrayList<VoldemortService>();
        SchedulerService scheduler = new SchedulerService(this.voldemortConfig.getSchedulerThreads(), SystemTime.INSTANCE);
        StorageService storageService = new StorageService(this.storeRepository, this.metadata, scheduler, this.voldemortConfig);
        this.asyncService = new AsyncOperationService(scheduler, 64);
        services.add(storageService);
        services.add(scheduler);
        services.add(this.asyncService);
        if (this.voldemortConfig.isHttpServerEnabled()) {
            services.add(new HttpService(this, storageService, this.storeRepository, RequestFormatType.VOLDEMORT_V1, this.voldemortConfig.getMaxThreads(), this.identityNode.getHttpPort()));
        }
        if (this.voldemortConfig.isSocketServerEnabled()) {
            SocketRequestHandlerFactory socketRequestHandlerFactory = new SocketRequestHandlerFactory(storageService, this.storeRepository, this.metadata, this.voldemortConfig, this.asyncService, null);
            if (this.voldemortConfig.getUseNioConnector()) {
                logger.info("Using NIO Connector.");
                services.add(new NioSocketService(socketRequestHandlerFactory, this.identityNode.getSocketPort(), this.voldemortConfig.getSocketBufferSize(), this.voldemortConfig.getNioConnectorSelectors(), "nio-socket-server", this.voldemortConfig.isJmxEnabled()));
            } else {
                logger.info("Using BIO Connector.");
                services.add(new SocketService(socketRequestHandlerFactory, this.identityNode.getSocketPort(), this.voldemortConfig.getCoreThreads(), this.voldemortConfig.getMaxThreads(), this.voldemortConfig.getSocketBufferSize(), "socket-server", this.voldemortConfig.isJmxEnabled()));
            }
        }
        if (this.voldemortConfig.isAdminServerEnabled()) {
            Rebalancer rebalancer = null;
            if (this.voldemortConfig.isEnableRebalanceService()) {
                RebalancerService rebalancerService = new RebalancerService(this.metadata, this.voldemortConfig, this.asyncService, scheduler);
                services.add(rebalancerService);
                rebalancer = rebalancerService.getRebalancer();
            }
            SocketRequestHandlerFactory adminRequestHandlerFactory = new SocketRequestHandlerFactory(storageService, this.storeRepository, this.metadata, this.voldemortConfig, this.asyncService, rebalancer);
            if (this.voldemortConfig.getUseNioConnector()) {
                logger.info("Using NIO Connector for Admin Service.");
                services.add(new NioSocketService(adminRequestHandlerFactory, this.identityNode.getAdminPort(), this.voldemortConfig.getAdminSocketBufferSize(), this.voldemortConfig.getNioAdminConnectorSelectors(), "admin-server", this.voldemortConfig.isJmxEnabled()));
            } else {
                logger.info("Using BIO Connector for Admin Service.");
                services.add(new SocketService(adminRequestHandlerFactory, this.identityNode.getAdminPort(), this.voldemortConfig.getAdminCoreThreads(), this.voldemortConfig.getAdminMaxThreads(), this.voldemortConfig.getAdminSocketBufferSize(), "admin-server", this.voldemortConfig.isJmxEnabled()));
            }
        }
        if (this.voldemortConfig.isGossipEnabled()) {
            services.add(new GossipService(this.metadata, scheduler, this.voldemortConfig));
        }
        if (this.voldemortConfig.isJmxEnabled()) {
            services.add(new JmxService(this, this.metadata.getCluster(), this.storeRepository, services));
        }
        return ImmutableList.copyOf(services);
    }

    @Override
    protected void startInner() throws VoldemortException {
        logger.info("Starting " + this.services.size() + " services.");
        long start = System.currentTimeMillis();
        for (VoldemortService service : this.services) {
            service.start();
        }
        long end = System.currentTimeMillis();
        logger.info("Startup completed in " + (end - start) + " ms.");
    }

    @Override
    protected void stopInner() throws VoldemortException {
        ArrayList<VoldemortException> exceptions = new ArrayList<VoldemortException>();
        logger.info("Stopping services:" + this.getIdentityNode().getId());
        for (VoldemortService service : Utils.reversed(this.services)) {
            try {
                service.stop();
            }
            catch (VoldemortException e) {
                exceptions.add(e);
                logger.error(e);
            }
        }
        logger.info("All services stopped for Node:" + this.getIdentityNode().getId());
        if (exceptions.size() > 0) {
            throw (VoldemortException)exceptions.get(0);
        }
    }

    public static void main(String[] args) throws Exception {
        VoldemortConfig config = null;
        try {
            if (args.length == 0) {
                config = VoldemortConfig.loadFromEnvironmentVariable();
            } else if (args.length == 1) {
                config = VoldemortConfig.loadFromVoldemortHome(args[0]);
            } else {
                Utils.croak("USAGE: java " + VoldemortServer.class.getName() + " [voldemort_home_dir]");
            }
        }
        catch (Exception e) {
            logger.error(e);
            Utils.croak("Error while loading configuration: " + e.getMessage());
        }
        final VoldemortServer server = new VoldemortServer(config);
        if (!server.isStarted()) {
            server.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (server.isStarted()) {
                    server.stop();
                }
            }
        });
    }

    public Node getIdentityNode() {
        return this.identityNode;
    }

    public List<VoldemortService> getServices() {
        return this.services;
    }

    public VoldemortService getService(ServiceType type) {
        for (VoldemortService service : this.services) {
            if (!service.getType().equals((Object)type)) continue;
            return service;
        }
        throw new IllegalStateException(type.getDisplayName() + " has not been initialized.");
    }

    public VoldemortConfig getVoldemortConfig() {
        return this.voldemortConfig;
    }

    public StoreRepository getStoreRepository() {
        return this.storeRepository;
    }

    public MetadataStore getMetadataStore() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxOperation(description="force restore data from replication")
    public void restoreDataFromReplication(int numberOfParallelTransfers) {
        AdminClient adminClient = RebalanceUtils.createTempAdminClient(this.voldemortConfig, this.metadata.getCluster(), numberOfParallelTransfers * 2, numberOfParallelTransfers * 2);
        try {
            adminClient.restoreDataFromReplications(this.metadata.getNodeId(), numberOfParallelTransfers);
        }
        finally {
            adminClient.stop();
        }
    }
}

