/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.store.bdb.BdbStorageConfiguration;
import voldemort.store.memory.CacheStorageConfiguration;
import voldemort.store.memory.InMemoryStorageConfiguration;
import voldemort.store.mysql.MysqlStorageConfiguration;
import voldemort.store.readonly.BinarySearchStrategy;
import voldemort.store.readonly.ReadOnlyStorageConfiguration;
import voldemort.utils.ConfigurationException;
import voldemort.utils.Props;
import voldemort.utils.UndefinedPropertyException;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VOLDEMORT_HOME_VAR_NAME = "VOLDEMORT_HOME";
    private static final String VOLDEMORT_NODE_ID_VAR_NAME = "VOLDEMORT_NODE_ID";
    public static int VOLDEMORT_DEFAULT_ADMIN_PORT = 6660;
    private int nodeId;
    private String voldemortHome;
    private String dataDirectory;
    private String metadataDirectory;
    private String slopStoreType;
    private long bdbCacheSize;
    private boolean bdbWriteTransactions;
    private boolean bdbFlushTransactions;
    private boolean bdbSortedDuplicates;
    private String bdbDataDirectory;
    private long bdbMaxLogFileSize;
    private int bdbBtreeFanout;
    private long bdbCheckpointBytes;
    private long bdbCheckpointMs;
    private boolean bdbOneEnvPerStore;
    private int bdbCleanerMinFileUtilization;
    private int bdbCleanerMinUtilization;
    private boolean bdbCursorPreload;
    private String mysqlUsername;
    private String mysqlPassword;
    private String mysqlDatabaseName;
    private String mysqlHost;
    private int mysqlPort;
    private int readOnlyBackups;
    private String readOnlyStorageDir;
    private String readOnlySearchStrategy;
    private int coreThreads;
    private int maxThreads;
    private int socketTimeoutMs;
    private int socketBufferSize;
    private boolean socketKeepAlive;
    private boolean useNioConnector;
    private int nioConnectorSelectors;
    private int nioAdminConnectorSelectors;
    private int clientRoutingTimeoutMs;
    private int clientMaxConnectionsPerNode;
    private int clientConnectionTimeoutMs;
    private int clientMaxThreads;
    private int clientThreadIdleMs;
    private int clientMaxQueuedRequests;
    private int schedulerThreads;
    private int numCleanupPermits;
    private RequestFormatType requestFormatType;
    private boolean enableSlop;
    private boolean enableGui;
    private boolean enableHttpServer;
    private boolean enableSocketServer;
    private boolean enableAdminServer;
    private boolean enableJmx;
    private boolean enableVerboseLogging;
    private boolean enableStatTracking;
    private boolean enableServerRouting;
    private boolean enableMetadataChecking;
    private boolean enableRedirectRouting;
    private boolean enableNetworkClassLoader;
    private boolean enableGossip;
    private boolean enableRebalanceService;
    private List<String> storageConfigurations;
    private Props allProps;
    private final long pusherPollMs;
    private int adminCoreThreads;
    private int adminMaxThreads;
    private int adminStreamBufferSize;
    private int adminSocketTimeout;
    private int adminConnectionTimeout;
    private long streamMaxReadBytesPerSec;
    private long streamMaxWriteBytesPerSec;
    private int gossipInterval;
    private String failureDetectorImplementation;
    private long failureDetectorBannagePeriod;
    private int failureDetectorThreshold;
    private int failureDetectorThresholdCountMinimum;
    private long failureDetectorThresholdInterval;
    private long failureDetectorAsyncRecoveryInterval;
    private volatile List<String> failureDetectorCatastrophicErrorTypes;
    private long failureDetectorRequestLengthThreshold;
    private int retentionCleanupFirstStartTimeInHour;
    private int retentionCleanupScheduledPeriodInHour;
    private int maxRebalancingAttempt;
    private int rebalancingTimeoutInSeconds;
    private int rebalancingServicePeriod;
    private int maxParallelStoresRebalancing;

    public int getGossipInterval() {
        return this.gossipInterval;
    }

    public void setGossipInterval(int gossipInterval) {
        this.gossipInterval = gossipInterval;
    }

    public VoldemortConfig(Properties props) {
        this(new Props(props));
    }

    public VoldemortConfig(Props props) {
        try {
            this.nodeId = props.getInt("node.id");
        }
        catch (UndefinedPropertyException e) {
            this.nodeId = this.getIntEnvVariable(VOLDEMORT_NODE_ID_VAR_NAME);
        }
        this.voldemortHome = props.getString("voldemort.home");
        this.dataDirectory = props.getString("data.directory", this.voldemortHome + File.separator + "data");
        this.metadataDirectory = props.getString("metadata.directory", this.voldemortHome + File.separator + "config");
        this.bdbCacheSize = props.getBytes("bdb.cache.size", 0xC800000L);
        this.bdbWriteTransactions = props.getBoolean("bdb.write.transactions", false);
        this.bdbFlushTransactions = props.getBoolean("bdb.flush.transactions", false);
        this.bdbDataDirectory = props.getString("bdb.data.directory", this.dataDirectory + File.separator + "bdb");
        this.bdbMaxLogFileSize = props.getBytes("bdb.max.logfile.size", 0x3C00000L);
        this.bdbBtreeFanout = props.getInt("bdb.btree.fanout", 512);
        this.bdbCheckpointBytes = props.getLong("bdb.checkpoint.interval.bytes", 0x1400000L);
        this.bdbCheckpointMs = props.getLong("bdb.checkpoint.interval.ms", 30000L);
        this.bdbSortedDuplicates = props.getBoolean("bdb.enable.sorted.duplicates", true);
        this.bdbOneEnvPerStore = props.getBoolean("bdb.one.env.per.store", false);
        this.bdbCleanerMinFileUtilization = props.getInt("bdb.cleaner.min.file.utilization", 5);
        this.bdbCleanerMinUtilization = props.getInt("bdb.cleaner.minUtilization", 50);
        this.bdbCursorPreload = props.getBoolean("bdb.cursor.preload", false);
        this.readOnlyBackups = props.getInt("readonly.backups", 1);
        this.readOnlySearchStrategy = props.getString("readonly.search.strategy", BinarySearchStrategy.class.getName());
        this.readOnlyStorageDir = props.getString("readonly.data.directory", this.dataDirectory + File.separator + "read-only");
        this.slopStoreType = props.getString("slop.store.engine", "bdb");
        this.mysqlUsername = props.getString("mysql.user", "root");
        this.mysqlPassword = props.getString("mysql.password", "");
        this.mysqlHost = props.getString("mysql.host", "localhost");
        this.mysqlPort = props.getInt("mysql.port", 3306);
        this.mysqlDatabaseName = props.getString("mysql.database", "voldemort");
        this.maxThreads = props.getInt("max.threads", 100);
        this.coreThreads = props.getInt("core.threads", Math.max(1, this.maxThreads / 2));
        this.adminMaxThreads = props.getInt("admin.max.threads", 20);
        this.adminCoreThreads = props.getInt("admin.core.threads", Math.max(1, this.adminMaxThreads / 2));
        this.adminStreamBufferSize = (int)props.getBytes("admin.streams.buffer.size", 10000000L);
        this.adminConnectionTimeout = props.getInt("admin.client.connection.timeout.sec", 60);
        this.adminSocketTimeout = props.getInt("admin.client.socket.timeout.sec", 86400);
        this.streamMaxReadBytesPerSec = props.getBytes("stream.read.byte.per.sec", 10000000L);
        this.streamMaxWriteBytesPerSec = props.getBytes("stream.write.byte.per.sec", 10000000L);
        this.socketTimeoutMs = props.getInt("socket.timeout.ms", 4000);
        this.socketBufferSize = (int)props.getBytes("socket.buffer.size", 32768L);
        this.socketKeepAlive = props.getBoolean("socket.keepalive", false);
        this.useNioConnector = props.getBoolean("enable.nio.connector", false);
        this.nioConnectorSelectors = props.getInt("nio.connector.selectors", Math.max(8, Runtime.getRuntime().availableProcessors()));
        this.nioAdminConnectorSelectors = props.getInt("nio.admin.connector.selectors", Math.max(8, Runtime.getRuntime().availableProcessors()));
        this.clientMaxConnectionsPerNode = props.getInt("client.max.connections.per.node", 5);
        this.clientConnectionTimeoutMs = props.getInt("client.connection.timeout.ms", 400);
        this.clientRoutingTimeoutMs = props.getInt("client.routing.timeout.ms", 5000);
        this.clientMaxThreads = props.getInt("client.max.threads", 100);
        this.clientThreadIdleMs = props.getInt("client.thread.idle.ms", 5000);
        this.clientMaxQueuedRequests = props.getInt("client.max.queued.requests", 1000);
        this.enableHttpServer = props.getBoolean("http.enable", true);
        this.enableSocketServer = props.getBoolean("socket.enable", true);
        this.enableAdminServer = props.getBoolean("admin.enable", true);
        this.enableJmx = props.getBoolean("jmx.enable", true);
        this.enableSlop = props.getBoolean("slop.enable", true);
        this.enableVerboseLogging = props.getBoolean("enable.verbose.logging", true);
        this.enableStatTracking = props.getBoolean("enable.stat.tracking", true);
        this.enableServerRouting = props.getBoolean("enable.server.routing", true);
        this.enableMetadataChecking = props.getBoolean("enable.metadata.checking", true);
        this.enableRedirectRouting = props.getBoolean("enable.redirect.routing", true);
        this.enableGossip = props.getBoolean("enable.gossip", false);
        this.enableRebalanceService = props.getBoolean("enable.rebalancing", true);
        this.gossipInterval = props.getInt("gossip.interval.ms", 30000);
        this.pusherPollMs = props.getInt("pusher.poll.ms", 120000);
        this.schedulerThreads = props.getInt("scheduler.threads", 6);
        this.numCleanupPermits = props.getInt("num.cleanup.permits", 1);
        this.storageConfigurations = props.getList("storage.configs", ImmutableList.of(BdbStorageConfiguration.class.getName(), MysqlStorageConfiguration.class.getName(), InMemoryStorageConfiguration.class.getName(), CacheStorageConfiguration.class.getName(), ReadOnlyStorageConfiguration.class.getName()));
        this.retentionCleanupFirstStartTimeInHour = props.getInt("retention.cleanup.first.start.hour", 0);
        this.retentionCleanupScheduledPeriodInHour = props.getInt("retention.cleanup.period.hours", 24);
        this.allProps = props;
        String requestFormatName = props.getString("request.format", RequestFormatType.VOLDEMORT_V1.getCode());
        this.requestFormatType = RequestFormatType.fromCode(requestFormatName);
        this.maxRebalancingAttempt = props.getInt("max.rebalancing.attempts", 3);
        this.rebalancingTimeoutInSeconds = props.getInt("rebalancing.timeout.seconds", 3600);
        this.rebalancingServicePeriod = props.getInt("rebalancing.service.period.ms", 1000);
        this.maxParallelStoresRebalancing = props.getInt("max.parallel.stores.rebalancing", 3);
        this.failureDetectorImplementation = props.getString("failuredetector.implementation", FailureDetectorConfig.DEFAULT_IMPLEMENTATION_CLASS_NAME);
        if (props.containsKey("client.node.bannage.ms") && !props.containsKey("failuredetector.bannage.period")) {
            props.put("failuredetector.bannage.period", props.get("client.node.bannage.ms"));
        }
        this.failureDetectorBannagePeriod = props.getLong("failuredetector.bannage.period", 30000L);
        this.failureDetectorThreshold = props.getInt("failuredetector.threshold", 80);
        this.failureDetectorThresholdCountMinimum = props.getInt("failuredetector.threshold.countminimum", 10);
        this.failureDetectorThresholdInterval = props.getLong("failuredetector.threshold.interval", 10000L);
        this.failureDetectorAsyncRecoveryInterval = props.getLong("failuredetector.asyncrecovery.interval", 10000L);
        this.failureDetectorCatastrophicErrorTypes = props.getList("failuredetector.catastrophic.error.types", FailureDetectorConfig.DEFAULT_CATASTROPHIC_ERROR_TYPES);
        this.failureDetectorRequestLengthThreshold = props.getLong("failuredetector.request.length.threshold", this.getSocketTimeoutMs());
        this.enableNetworkClassLoader = props.getBoolean("enable.network.classloader", false);
        this.validateParams();
    }

    private void validateParams() {
        if (this.coreThreads < 0) {
            throw new IllegalArgumentException("core.threads cannot be less than 1");
        }
        if (this.coreThreads > this.maxThreads) {
            throw new IllegalArgumentException("core.threads cannot be greater than max.threads.");
        }
        if (this.maxThreads < 1) {
            throw new ConfigurationException("max.threads cannot be less than 1.");
        }
        if (this.pusherPollMs < 1L) {
            throw new ConfigurationException("pusher.poll.ms cannot be less than 1.");
        }
        if (this.socketTimeoutMs < 0) {
            throw new ConfigurationException("socket.timeout.ms must be 0 or more ms.");
        }
        if (this.clientRoutingTimeoutMs < 0) {
            throw new ConfigurationException("routing.timeout.ms must be 0 or more ms.");
        }
        if (this.schedulerThreads < 1) {
            throw new ConfigurationException("Must have at least 1 scheduler thread, " + this.schedulerThreads + " set.");
        }
        if (this.enableServerRouting && !this.enableSocketServer) {
            throw new ConfigurationException("Server-side routing is enabled, this requires the socket server to also be enabled.");
        }
    }

    private int getIntEnvVariable(String name) {
        String var = System.getenv(name);
        if (var == null) {
            throw new ConfigurationException("The environment variable " + name + " is not defined.");
        }
        try {
            return Integer.parseInt(var);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid format for environment variable " + name + ", expecting an integer.", e);
        }
    }

    public static VoldemortConfig loadFromEnvironmentVariable() {
        String voldemortHome = System.getenv(VOLDEMORT_HOME_VAR_NAME);
        if (voldemortHome == null) {
            throw new ConfigurationException("No environment variable VOLDEMORT_HOME has been defined, set it!");
        }
        return VoldemortConfig.loadFromVoldemortHome(voldemortHome);
    }

    public static VoldemortConfig loadFromVoldemortHome(String voldemortHome) {
        if (!Utils.isReadableDir(voldemortHome)) {
            throw new ConfigurationException("Attempt to load configuration from VOLDEMORT_HOME, " + voldemortHome + " failed. That is not a readable directory.");
        }
        String propertiesFile = voldemortHome + File.separator + "config" + File.separator + "server.properties";
        if (!Utils.isReadableFile(propertiesFile)) {
            throw new ConfigurationException(propertiesFile + " is not a readable configuration file.");
        }
        Props properties = null;
        try {
            properties = new Props(new File(propertiesFile));
            properties.put("voldemort.home", voldemortHome);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return new VoldemortConfig(properties);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public String getVoldemortHome() {
        return this.voldemortHome;
    }

    public void setVoldemortHome(String voldemortHome) {
        this.voldemortHome = voldemortHome;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getMetadataDirectory() {
        return this.metadataDirectory;
    }

    public void setMetadataDirectory(String metadataDirectory) {
        this.metadataDirectory = metadataDirectory;
    }

    public long getBdbCacheSize() {
        return this.bdbCacheSize;
    }

    public void setBdbCacheSize(int bdbCacheSize) {
        this.bdbCacheSize = bdbCacheSize;
    }

    public boolean isBdbFlushTransactionsEnabled() {
        return this.bdbFlushTransactions;
    }

    public void setBdbFlushTransactions(boolean bdbSyncTransactions) {
        this.bdbFlushTransactions = bdbSyncTransactions;
    }

    public String getBdbDataDirectory() {
        return this.bdbDataDirectory;
    }

    public void setBdbDataDirectory(String bdbDataDirectory) {
        this.bdbDataDirectory = bdbDataDirectory;
    }

    public long getBdbMaxLogFileSize() {
        return this.bdbMaxLogFileSize;
    }

    public void setBdbMaxLogFileSize(long bdbMaxLogFileSize) {
        this.bdbMaxLogFileSize = bdbMaxLogFileSize;
    }

    public int getBdbCleanerMinFileUtilization() {
        return this.bdbCleanerMinFileUtilization;
    }

    public final void setBdbCleanerMinFileUtilization(int minFileUtilization) {
        if (minFileUtilization < 0 || minFileUtilization > 50) {
            throw new IllegalArgumentException("minFileUtilization should be between 0 and 50 (both inclusive)");
        }
        this.bdbCleanerMinFileUtilization = minFileUtilization;
    }

    public int getBdbCleanerMinUtilization() {
        return this.bdbCleanerMinUtilization;
    }

    public final void setBdbCleanerMinUtilization(int minUtilization) {
        if (minUtilization < 0 || minUtilization > 90) {
            throw new IllegalArgumentException("minUtilization should be between 0 and 90 (both inclusive)");
        }
        this.bdbCleanerMinUtilization = minUtilization;
    }

    public int getBdbBtreeFanout() {
        return this.bdbBtreeFanout;
    }

    public void setBdbBtreeFanout(int bdbBtreeFanout) {
        this.bdbBtreeFanout = bdbBtreeFanout;
    }

    public boolean getBdbCursorPreload() {
        return this.bdbCursorPreload;
    }

    public void setBdbCursorPreload(boolean bdbCursorPreload) {
        this.bdbCursorPreload = bdbCursorPreload;
    }

    public int getCoreThreads() {
        return this.coreThreads;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getAdminCoreThreads() {
        return this.adminCoreThreads;
    }

    public void setAdminCoreThreads(int coreThreads) {
        this.adminCoreThreads = coreThreads;
    }

    public int getAdminMaxThreads() {
        return this.adminMaxThreads;
    }

    public void setAdminMaxThreads(int maxThreads) {
        this.adminMaxThreads = maxThreads;
    }

    public boolean isHttpServerEnabled() {
        return this.enableHttpServer;
    }

    public void setEnableHttpServer(boolean enableHttpServer) {
        this.enableHttpServer = enableHttpServer;
    }

    public boolean isSocketServerEnabled() {
        return this.enableSocketServer;
    }

    public void setAdminServerEnabled(boolean enableSocketServer) {
        this.enableSocketServer = enableSocketServer;
    }

    public boolean isAdminServerEnabled() {
        return this.enableAdminServer;
    }

    public long getStreamMaxReadBytesPerSec() {
        return this.streamMaxReadBytesPerSec;
    }

    public void setStreamMaxReadBytesPerSec(long streamMaxReadBytesPerSec) {
        this.streamMaxReadBytesPerSec = streamMaxReadBytesPerSec;
    }

    public long getStreamMaxWriteBytesPerSec() {
        return this.streamMaxWriteBytesPerSec;
    }

    public void setStreamMaxWriteBytesPerSec(long streamMaxWriteBytesPerSec) {
        this.streamMaxWriteBytesPerSec = streamMaxWriteBytesPerSec;
    }

    public void setEnableAdminServer(boolean enableAdminServer) {
        this.enableAdminServer = enableAdminServer;
    }

    public boolean isJmxEnabled() {
        return this.enableJmx;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public long getPusherPollMs() {
        return this.pusherPollMs;
    }

    public boolean isGuiEnabled() {
        return this.enableGui;
    }

    public void setEnableGui(boolean enableGui) {
        this.enableGui = enableGui;
    }

    public String getMysqlUsername() {
        return this.mysqlUsername;
    }

    public void setMysqlUsername(String mysqlUsername) {
        this.mysqlUsername = mysqlUsername;
    }

    public String getMysqlPassword() {
        return this.mysqlPassword;
    }

    public void setMysqlPassword(String mysqlPassword) {
        this.mysqlPassword = mysqlPassword;
    }

    public String getMysqlDatabaseName() {
        return this.mysqlDatabaseName;
    }

    public void setMysqlDatabaseName(String mysqlDatabaseName) {
        this.mysqlDatabaseName = mysqlDatabaseName;
    }

    public String getMysqlHost() {
        return this.mysqlHost;
    }

    public void setMysqlHost(String mysqlHost) {
        this.mysqlHost = mysqlHost;
    }

    public int getMysqlPort() {
        return this.mysqlPort;
    }

    public void setMysqlPort(int mysqlPort) {
        this.mysqlPort = mysqlPort;
    }

    public String getSlopStoreType() {
        return this.slopStoreType;
    }

    public void setSlopStoreType(String slopStoreType) {
        this.slopStoreType = slopStoreType;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public int getRoutingTimeoutMs() {
        return this.clientRoutingTimeoutMs;
    }

    public void setClientRoutingTimeoutMs(int routingTimeoutMs) {
        this.clientRoutingTimeoutMs = routingTimeoutMs;
    }

    public int getClientMaxConnectionsPerNode() {
        return this.clientMaxConnectionsPerNode;
    }

    public void setClientMaxConnectionsPerNode(int maxConnectionsPerNode) {
        this.clientMaxConnectionsPerNode = maxConnectionsPerNode;
    }

    public int getClientConnectionTimeoutMs() {
        return this.clientConnectionTimeoutMs;
    }

    public void setClientConnectionTimeoutMs(int connectionTimeoutMs) {
        this.clientConnectionTimeoutMs = connectionTimeoutMs;
    }

    @Deprecated
    public int getClientNodeBannageMs() {
        return (int)this.failureDetectorBannagePeriod;
    }

    @Deprecated
    public void setClientNodeBannageMs(int nodeBannageMs) {
        this.failureDetectorBannagePeriod = nodeBannageMs;
    }

    public int getClientMaxThreads() {
        return this.clientMaxThreads;
    }

    public void setClientMaxThreads(int clientMaxThreads) {
        this.clientMaxThreads = clientMaxThreads;
    }

    public int getClientThreadIdleMs() {
        return this.clientThreadIdleMs;
    }

    public void setClientThreadIdleMs(int clientThreadIdleMs) {
        this.clientThreadIdleMs = clientThreadIdleMs;
    }

    public int getClientMaxQueuedRequests() {
        return this.clientMaxQueuedRequests;
    }

    public void setClientMaxQueuedRequests(int clientMaxQueuedRequests) {
        this.clientMaxQueuedRequests = clientMaxQueuedRequests;
    }

    public boolean isSlopEnabled() {
        return this.enableSlop;
    }

    public void setEnableSlop(boolean enableSlop) {
        this.enableSlop = enableSlop;
    }

    public boolean isVerboseLoggingEnabled() {
        return this.enableVerboseLogging;
    }

    public void setEnableVerboseLogging(boolean enableVerboseLogging) {
        this.enableVerboseLogging = enableVerboseLogging;
    }

    public boolean isStatTrackingEnabled() {
        return this.enableStatTracking;
    }

    public void setEnableStatTracking(boolean enableStatTracking) {
        this.enableStatTracking = enableStatTracking;
    }

    public boolean isMetadataCheckingEnabled() {
        return this.enableMetadataChecking;
    }

    public void setEnableMetadataChecking(boolean enableMetadataChecking) {
        this.enableMetadataChecking = enableMetadataChecking;
    }

    public boolean isRedirectRoutingEnabled() {
        return this.enableRedirectRouting;
    }

    public void setEnableRedirectRouting(boolean enableRedirectRouting) {
        this.enableRedirectRouting = enableRedirectRouting;
    }

    public long getBdbCheckpointBytes() {
        return this.bdbCheckpointBytes;
    }

    public void setBdbCheckpointBytes(long bdbCheckpointBytes) {
        this.bdbCheckpointBytes = bdbCheckpointBytes;
    }

    public long getBdbCheckpointMs() {
        return this.bdbCheckpointMs;
    }

    public void setBdbCheckpointMs(long bdbCheckpointMs) {
        this.bdbCheckpointMs = bdbCheckpointMs;
    }

    public int getSchedulerThreads() {
        return this.schedulerThreads;
    }

    public void setSchedulerThreads(int schedulerThreads) {
        this.schedulerThreads = schedulerThreads;
    }

    public String getReadOnlyDataStorageDirectory() {
        return this.readOnlyStorageDir;
    }

    public void setReadOnlyDataStorageDirectory(String readOnlyStorageDir) {
        this.readOnlyStorageDir = readOnlyStorageDir;
    }

    public int getReadOnlyBackups() {
        return this.readOnlyBackups;
    }

    public void setReadOnlyBackups(int readOnlyBackups) {
        this.readOnlyBackups = readOnlyBackups;
    }

    public boolean isBdbWriteTransactionsEnabled() {
        return this.bdbWriteTransactions;
    }

    public void setBdbWriteTransactions(boolean bdbWriteTransactions) {
        this.bdbWriteTransactions = bdbWriteTransactions;
    }

    public boolean isBdbSortedDuplicatesEnabled() {
        return this.bdbSortedDuplicates;
    }

    public void setBdbSortedDuplicates(boolean enable) {
        this.bdbSortedDuplicates = enable;
    }

    public void setBdbOneEnvPerStore(boolean bdbOneEnvPerStore) {
        this.bdbOneEnvPerStore = bdbOneEnvPerStore;
    }

    public boolean isBdbOneEnvPerStore() {
        return this.bdbOneEnvPerStore;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean on) {
        this.socketKeepAlive = on;
    }

    public boolean getUseNioConnector() {
        return this.useNioConnector;
    }

    public void setUseNioConnector(boolean useNio) {
        this.useNioConnector = useNio;
    }

    public int getNioConnectorSelectors() {
        return this.nioConnectorSelectors;
    }

    public void setNioConnectorSelectors(int nioConnectorSelectors) {
        this.nioConnectorSelectors = nioConnectorSelectors;
    }

    public int getNioAdminConnectorSelectors() {
        return this.nioAdminConnectorSelectors;
    }

    public void setNioAdminConnectorSelectors(int nioAdminConnectorSelectors) {
        this.nioAdminConnectorSelectors = nioAdminConnectorSelectors;
    }

    public int getAdminSocketBufferSize() {
        return this.adminStreamBufferSize;
    }

    public void setAdminSocketBufferSize(int socketBufferSize) {
        this.adminStreamBufferSize = socketBufferSize;
    }

    public List<String> getStorageConfigurations() {
        return this.storageConfigurations;
    }

    public void setStorageConfigurations(List<String> storageConfigurations) {
        this.storageConfigurations = storageConfigurations;
    }

    public Props getAllProps() {
        return this.allProps;
    }

    public void setRequestFormatType(RequestFormatType type) {
        this.requestFormatType = type;
    }

    public RequestFormatType getRequestFormatType() {
        return this.requestFormatType;
    }

    public boolean isServerRoutingEnabled() {
        return this.enableServerRouting;
    }

    public void setEnableServerRouting(boolean enableServerRouting) {
        this.enableServerRouting = enableServerRouting;
    }

    public int getNumCleanupPermits() {
        return this.numCleanupPermits;
    }

    public void setNumCleanupPermits(int numCleanupPermits) {
        this.numCleanupPermits = numCleanupPermits;
    }

    public String getFailureDetectorImplementation() {
        return this.failureDetectorImplementation;
    }

    public void setFailureDetectorImplementation(String failureDetectorImplementation) {
        this.failureDetectorImplementation = failureDetectorImplementation;
    }

    public long getFailureDetectorBannagePeriod() {
        return this.failureDetectorBannagePeriod;
    }

    public void setFailureDetectorBannagePeriod(long failureDetectorBannagePeriod) {
        this.failureDetectorBannagePeriod = failureDetectorBannagePeriod;
    }

    public int getFailureDetectorThreshold() {
        return this.failureDetectorThreshold;
    }

    public void setFailureDetectorThreshold(int failureDetectorThreshold) {
        this.failureDetectorThreshold = failureDetectorThreshold;
    }

    public int getFailureDetectorThresholdCountMinimum() {
        return this.failureDetectorThresholdCountMinimum;
    }

    public void setFailureDetectorThresholdCountMinimum(int failureDetectorThresholdCountMinimum) {
        this.failureDetectorThresholdCountMinimum = failureDetectorThresholdCountMinimum;
    }

    public long getFailureDetectorThresholdInterval() {
        return this.failureDetectorThresholdInterval;
    }

    public void setFailureDetectorThresholdInterval(long failureDetectorThresholdInterval) {
        this.failureDetectorThresholdInterval = failureDetectorThresholdInterval;
    }

    public long getFailureDetectorAsyncRecoveryInterval() {
        return this.failureDetectorAsyncRecoveryInterval;
    }

    public void setFailureDetectorAsyncRecoveryInterval(long failureDetectorAsyncRecoveryInterval) {
        this.failureDetectorAsyncRecoveryInterval = failureDetectorAsyncRecoveryInterval;
    }

    public List<String> getFailureDetectorCatastrophicErrorTypes() {
        return this.failureDetectorCatastrophicErrorTypes;
    }

    public void setFailureDetectorCatastrophicErrorTypes(List<String> failureDetectorCatastrophicErrorTypes) {
        this.failureDetectorCatastrophicErrorTypes = failureDetectorCatastrophicErrorTypes;
    }

    public long getFailureDetectorRequestLengthThreshold() {
        return this.failureDetectorRequestLengthThreshold;
    }

    public void setFailureDetectorRequestLengthThreshold(long failureDetectorRequestLengthThreshold) {
        this.failureDetectorRequestLengthThreshold = failureDetectorRequestLengthThreshold;
    }

    public int getRetentionCleanupFirstStartTimeInHour() {
        return this.retentionCleanupFirstStartTimeInHour;
    }

    public void setRetentionCleanupFirstStartTimeInHour(int retentionCleanupFirstStartTimeInHour) {
        this.retentionCleanupFirstStartTimeInHour = retentionCleanupFirstStartTimeInHour;
    }

    public int getRetentionCleanupScheduledPeriodInHour() {
        return this.retentionCleanupScheduledPeriodInHour;
    }

    public void setRetentionCleanupScheduledPeriodInHour(int retentionCleanupScheduledPeriodInHour) {
        this.retentionCleanupScheduledPeriodInHour = retentionCleanupScheduledPeriodInHour;
    }

    public int getAdminSocketTimeout() {
        return this.adminSocketTimeout;
    }

    public void setAdminSocketTimeout(int adminSocketTimeout) {
        this.adminSocketTimeout = adminSocketTimeout;
    }

    public int getAdminConnectionTimeout() {
        return this.adminConnectionTimeout;
    }

    public void setAdminConnectionTimeout(int adminConnectionTimeout) {
        this.adminConnectionTimeout = adminConnectionTimeout;
    }

    public void setMaxRebalancingAttempt(int maxRebalancingAttempt) {
        this.maxRebalancingAttempt = maxRebalancingAttempt;
    }

    public int getMaxRebalancingAttempt() {
        return this.maxRebalancingAttempt;
    }

    public int getRebalancingTimeout() {
        return this.rebalancingTimeoutInSeconds;
    }

    public void setRebalancingTimeout(int rebalancingTimeout) {
        this.rebalancingTimeoutInSeconds = rebalancingTimeout;
    }

    public VoldemortConfig(int nodeId, String voldemortHome) {
        this(new Props().with("node.id", nodeId).with("voldemort.home", voldemortHome));
    }

    public boolean isGossipEnabled() {
        return this.enableGossip;
    }

    public void setEnableGossip(boolean enableGossip) {
        this.enableGossip = enableGossip;
    }

    public String getReadOnlySearchStrategy() {
        return this.readOnlySearchStrategy;
    }

    public void setReadOnlySearchStrategy(String readOnlySearchStrategy) {
        this.readOnlySearchStrategy = readOnlySearchStrategy;
    }

    public boolean isNetworkClassLoaderEnabled() {
        return this.enableNetworkClassLoader;
    }

    public void setEnableNetworkClassLoader(boolean enableNetworkClassLoader) {
        this.enableNetworkClassLoader = enableNetworkClassLoader;
    }

    public int getRebalancingServicePeriod() {
        return this.rebalancingServicePeriod;
    }

    public void setEnableRebalanceService(boolean enableRebalanceService) {
        this.enableRebalanceService = enableRebalanceService;
    }

    public boolean isEnableRebalanceService() {
        return this.enableRebalanceService;
    }

    public int getMaxParallelStoresRebalancing() {
        return this.maxParallelStoresRebalancing;
    }

    public void setMaxParallelStoresRebalancing(int maxParallelStoresRebalancing) {
        this.maxParallelStoresRebalancing = maxParallelStoresRebalancing;
    }
}

