/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Threadsafe
public class StoreRepository {
    private volatile StorageEngine<ByteArray, Slop> slopStore;
    private final ConcurrentMap<String, Store<ByteArray, byte[]>> localStores = new ConcurrentHashMap<String, Store<ByteArray, byte[]>>();
    private final ConcurrentMap<String, StorageEngine<ByteArray, byte[]>> storageEngines = new ConcurrentHashMap<String, StorageEngine<ByteArray, byte[]>>();
    private final ConcurrentMap<String, Store<ByteArray, byte[]>> routedStores = new ConcurrentHashMap<String, Store<ByteArray, byte[]>>();
    private final ConcurrentMap<Pair<String, Integer>, Store<ByteArray, byte[]>> nodeStores = new ConcurrentHashMap<Pair<String, Integer>, Store<ByteArray, byte[]>>();
    private final ConcurrentMap<Pair<String, Integer>, Store<ByteArray, byte[]>> redirectingSocketStores = new ConcurrentHashMap<Pair<String, Integer>, Store<ByteArray, byte[]>>();

    public boolean hasLocalStore(String name) {
        return this.localStores.containsKey(name);
    }

    public Store<ByteArray, byte[]> getLocalStore(String storeName) {
        return (Store)this.localStores.get(storeName);
    }

    public void addLocalStore(Store<ByteArray, byte[]> store) {
        Store<ByteArray, byte[]> found = this.localStores.putIfAbsent(store.getName(), store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' has already been initialized.");
        }
    }

    public List<Store<ByteArray, byte[]>> getAllLocalStores() {
        return new ArrayList<Store<ByteArray, byte[]>>(this.localStores.values());
    }

    public boolean hasStorageEngine(String name) {
        return this.storageEngines.containsKey(name);
    }

    public StorageEngine<ByteArray, byte[]> getStorageEngine(String storeName) {
        return (StorageEngine)this.storageEngines.get(storeName);
    }

    public void addStorageEngine(StorageEngine<ByteArray, byte[]> engine) {
        StorageEngine<ByteArray, byte[]> found = this.storageEngines.putIfAbsent(engine.getName(), engine);
        if (found != null) {
            throw new VoldemortException("Storage Engine '" + engine.getName() + "' has already been initialized.");
        }
    }

    public List<StorageEngine<ByteArray, byte[]>> getAllStorageEngines() {
        return new ArrayList<StorageEngine<ByteArray, byte[]>>(this.storageEngines.values());
    }

    public List<StorageEngine<ByteArray, byte[]>> getStorageEnginesByClass(Class<? extends StorageEngine<?, ?>> c) {
        ArrayList<StorageEngine<ByteArray, byte[]>> l = new ArrayList<StorageEngine<ByteArray, byte[]>>();
        for (StorageEngine engine : this.storageEngines.values()) {
            if (!engine.getClass().equals(c)) continue;
            l.add(engine);
        }
        return l;
    }

    public boolean hasRoutedStore(String name) {
        return this.routedStores.containsKey(name);
    }

    public Store<ByteArray, byte[]> getRoutedStore(String storeName) {
        return (Store)this.routedStores.get(storeName);
    }

    public void addRoutedStore(Store<ByteArray, byte[]> store) {
        Store<ByteArray, byte[]> found = this.routedStores.putIfAbsent(store.getName(), store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' has already been initialized.");
        }
    }

    public List<Store<ByteArray, byte[]>> getAllRoutedStores() {
        return new ArrayList<Store<ByteArray, byte[]>>(this.routedStores.values());
    }

    public boolean hasNodeStore(String name, int nodeId) {
        return this.nodeStores.containsKey(Pair.create(name, nodeId));
    }

    public Store<ByteArray, byte[]> getNodeStore(String storeName, Integer id) {
        return (Store)this.nodeStores.get(Pair.create(storeName, id));
    }

    public void addNodeStore(int nodeId, Store<ByteArray, byte[]> store) {
        Pair<String, Integer> key = Pair.create(store.getName(), nodeId);
        Store<ByteArray, byte[]> found = this.nodeStores.putIfAbsent(key, store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' for node " + nodeId + " has already been initialized.");
        }
    }

    public List<Pair<Integer, Store<ByteArray, byte[]>>> getAllNodeStores() {
        ArrayList<Pair<Integer, Store<ByteArray, byte[]>>> vals = new ArrayList<Pair<Integer, Store<ByteArray, byte[]>>>();
        for (Map.Entry entry : this.nodeStores.entrySet()) {
            vals.add(Pair.create(((Pair)entry.getKey()).getSecond(), entry.getValue()));
        }
        return vals;
    }

    public boolean hasRedirectingSocketStore(String name, int nodeId) {
        return this.redirectingSocketStores.containsKey(Pair.create(name, nodeId));
    }

    public Store<ByteArray, byte[]> getRedirectingSocketStore(String storeName, Integer id) {
        return (Store)this.redirectingSocketStores.get(Pair.create(storeName, id));
    }

    public void addRedirectingSocketStore(int nodeId, Store<ByteArray, byte[]> store) {
        Pair<String, Integer> key = Pair.create(store.getName(), nodeId);
        Store<ByteArray, byte[]> found = this.redirectingSocketStores.putIfAbsent(key, store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' for node " + nodeId + " has already been initialized.");
        }
    }

    public StorageEngine<ByteArray, Slop> getSlopStore() {
        if (this.slopStore == null) {
            throw new IllegalStateException("Slop store has not been set!");
        }
        return this.slopStore;
    }

    public void setSlopStore(StorageEngine<ByteArray, Slop> slopStore) {
        this.slopStore = slopStore;
    }

    public boolean hasSlopStore() {
        return this.slopStore != null;
    }
}

