/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import voldemort.serialization.SerializationException;
import voldemort.serialization.Serializer;
import voldemort.serialization.json.JsonTypeDefinition;
import voldemort.serialization.json.JsonTypes;
import voldemort.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonTypeSerializer
implements Serializer<Object> {
    private static final int MAX_SEQ_LENGTH = 0x3FFFFFFF;
    private final boolean hasVersion;
    private final SortedMap<Integer, JsonTypeDefinition> typeDefVersions;

    public JsonTypeSerializer(String typeDef) {
        this(JsonTypeDefinition.fromJson(typeDef));
    }

    public JsonTypeSerializer(String typeDef, boolean hasVersion) {
        this(JsonTypeDefinition.fromJson(typeDef), hasVersion);
    }

    public JsonTypeSerializer(JsonTypeDefinition typeDef) {
        this.hasVersion = false;
        this.typeDefVersions = new TreeMap<Integer, JsonTypeDefinition>();
        this.typeDefVersions.put(0, typeDef);
    }

    public JsonTypeSerializer(JsonTypeDefinition typeDef, boolean hasVersion) {
        this.hasVersion = hasVersion;
        this.typeDefVersions = new TreeMap<Integer, JsonTypeDefinition>();
        this.typeDefVersions.put(0, typeDef);
    }

    public JsonTypeSerializer(Map<Integer, JsonTypeDefinition> typeDefVersions) {
        this.hasVersion = true;
        this.typeDefVersions = new TreeMap<Integer, JsonTypeDefinition>(typeDefVersions);
    }

    @Override
    public byte[] toBytes(Object object) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        try {
            this.toBytes(object, output);
            output.flush();
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public void toBytes(Object object, DataOutputStream output) throws IOException {
        Integer newestVersion = this.typeDefVersions.lastKey();
        JsonTypeDefinition typeDef = (JsonTypeDefinition)this.typeDefVersions.get(newestVersion);
        if (this.hasVersion) {
            output.writeByte(newestVersion.byteValue());
        }
        this.write(output, object, typeDef.getType());
    }

    @Override
    public Object toObject(byte[] bytes) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            return this.toObject(input);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public Object toObject(DataInputStream input) throws IOException {
        JsonTypeDefinition typeDef;
        Integer version = 0;
        if (this.hasVersion) {
            version = input.readByte();
        }
        if ((typeDef = (JsonTypeDefinition)this.typeDefVersions.get(version)) == null) {
            throw new SerializationException("No schema found for schema version " + version + ".");
        }
        return this.read(input, typeDef.getType());
    }

    private void write(DataOutputStream output, Object object, Object type) throws IOException {
        try {
            if (type instanceof Map) {
                if (object != null && !(object instanceof Map)) {
                    throw new SerializationException("Expected Map, but got " + object.getClass() + ": " + object);
                }
                this.writeMap(output, (Map)object, (Map)type);
            } else if (type instanceof List) {
                if (object != null && !(object instanceof List)) {
                    throw new SerializationException("Expected List but got " + object.getClass() + ": " + object);
                }
                this.writeList(output, (List)object, (List)type);
            } else if (type instanceof JsonTypes) {
                JsonTypes jsonType = (JsonTypes)((Object)type);
                switch (jsonType) {
                    case STRING: {
                        this.writeString(output, (String)object);
                        break;
                    }
                    case INT8: {
                        this.writeInt8(output, (Byte)object);
                        break;
                    }
                    case INT16: {
                        this.writeInt16(output, this.coerceToShort(object));
                        break;
                    }
                    case INT32: {
                        this.writeInt32(output, this.coerceToInteger(object));
                        break;
                    }
                    case INT64: {
                        this.writeInt64(output, this.coerceToLong(object));
                        break;
                    }
                    case FLOAT32: {
                        this.writeFloat32(output, this.coerceToFloat(object));
                        break;
                    }
                    case FLOAT64: {
                        this.writeFloat64(output, this.coerceToDouble(object));
                        break;
                    }
                    case DATE: {
                        this.writeDate(output, this.coerceToDate(object));
                        break;
                    }
                    case BYTES: {
                        this.writeBytes(output, (byte[])object);
                        break;
                    }
                    case BOOLEAN: {
                        this.writeBoolean(output, (Boolean)object);
                        break;
                    }
                    default: {
                        throw new SerializationException("Unknown type: " + type);
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw new SerializationException("Expected type " + type + " but got object of incompatible type " + object.getClass().getName() + ".", e);
        }
    }

    private Object read(DataInputStream stream, Object type) throws IOException {
        if (type instanceof Map) {
            return this.readMap(stream, (Map)type);
        }
        if (type instanceof List) {
            return this.readList(stream, (List)type);
        }
        if (type instanceof JsonTypes) {
            JsonTypes jsonType = (JsonTypes)((Object)type);
            switch (jsonType) {
                case BOOLEAN: {
                    return this.readBoolean(stream);
                }
                case INT8: {
                    return this.readInt8(stream);
                }
                case INT16: {
                    return this.readInt16(stream);
                }
                case INT32: {
                    return this.readInt32(stream);
                }
                case INT64: {
                    return this.readInt64(stream);
                }
                case FLOAT32: {
                    return this.readFloat32(stream);
                }
                case FLOAT64: {
                    return this.readFloat64(stream);
                }
                case DATE: {
                    return this.readDate(stream);
                }
                case BYTES: {
                    return this.readBytes(stream);
                }
                case STRING: {
                    return this.readString(stream);
                }
            }
            throw new SerializationException("Unknown type: " + type);
        }
        throw new SerializationException("Unknown type of class " + type.getClass());
    }

    private void writeBoolean(DataOutputStream output, Boolean b) throws IOException {
        if (b == null) {
            output.writeByte(-1);
        } else if (b.booleanValue()) {
            output.writeByte(1);
        } else {
            output.write(0);
        }
    }

    private Boolean readBoolean(DataInputStream stream) throws IOException {
        byte b = stream.readByte();
        if (b < 0) {
            return null;
        }
        if (b == 0) {
            return false;
        }
        return true;
    }

    private Short coerceToShort(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == Short.class) {
            return (Short)o;
        }
        if (c == Byte.class) {
            return ((Byte)o).shortValue();
        }
        throw new SerializationException("Object of type " + c.getName() + " cannot be coerced to type " + (Object)((Object)JsonTypes.INT16) + " as the schema specifies.");
    }

    private Integer coerceToInteger(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == Integer.class) {
            return (Integer)o;
        }
        if (c == Byte.class) {
            return ((Byte)o).intValue();
        }
        if (c == Short.class) {
            return ((Short)o).intValue();
        }
        throw new SerializationException("Object of type " + c.getName() + " cannot be coerced to type " + (Object)((Object)JsonTypes.INT32) + " as the schema specifies.");
    }

    private Long coerceToLong(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == Long.class) {
            return (Long)o;
        }
        if (c == Byte.class) {
            return ((Byte)o).longValue();
        }
        if (c == Short.class) {
            return ((Short)o).longValue();
        }
        if (c == Integer.class) {
            return ((Integer)o).longValue();
        }
        throw new SerializationException("Object of type " + c.getName() + " cannot be coerced to type " + (Object)((Object)JsonTypes.INT64) + " as the schema specifies.");
    }

    private Float coerceToFloat(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == Float.class) {
            return (Float)o;
        }
        if (c == Byte.class) {
            return Float.valueOf(((Byte)o).floatValue());
        }
        if (c == Short.class) {
            return Float.valueOf(((Short)o).floatValue());
        }
        if (c == Integer.class) {
            return Float.valueOf(((Integer)o).floatValue());
        }
        throw new SerializationException("Object of type " + c.getName() + " cannot be coerced to type " + (Object)((Object)JsonTypes.FLOAT32) + " as the schema specifies.");
    }

    private Double coerceToDouble(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == Double.class) {
            return (Double)o;
        }
        if (c == Byte.class) {
            return ((Byte)o).doubleValue();
        }
        if (c == Short.class) {
            return ((Short)o).doubleValue();
        }
        if (c == Integer.class) {
            return ((Integer)o).doubleValue();
        }
        if (c == Float.class) {
            return ((Float)o).doubleValue();
        }
        throw new SerializationException("Object of type " + c.getName() + " cannot be coerced to type " + (Object)((Object)JsonTypes.FLOAT32) + " as the schema specifies.");
    }

    private void writeString(DataOutputStream stream, String s) throws IOException {
        this.writeBytes(stream, s == null ? null : s.getBytes("UTF-8"));
    }

    private String readString(DataInputStream stream) throws IOException {
        byte[] bytes = this.readBytes(stream);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    private Byte readInt8(DataInputStream stream) throws IOException {
        byte b = stream.readByte();
        if (b == -128) {
            return null;
        }
        return b;
    }

    private void writeInt8(DataOutputStream output, Byte b) throws IOException {
        if (b == null) {
            output.writeByte(-128);
        } else {
            if (b == -128) {
                throw new SerializationException("Underflow: attempt to store -128 in int8, but minimum value is -129.");
            }
            output.writeByte(b.byteValue());
        }
    }

    private Short readInt16(DataInputStream stream) throws IOException {
        short s = stream.readShort();
        if (s == Short.MIN_VALUE) {
            return null;
        }
        return s;
    }

    private void writeInt16(DataOutputStream output, Short s) throws IOException {
        if (s == null) {
            output.writeShort(Short.MIN_VALUE);
        } else {
            if (s == Short.MIN_VALUE) {
                throw new SerializationException("Underflow: attempt to store -32768 in int16, but minimum value is -32769.");
            }
            output.writeShort(s.shortValue());
        }
    }

    private Integer readInt32(DataInputStream stream) throws IOException {
        int i = stream.readInt();
        if (i == Integer.MIN_VALUE) {
            return null;
        }
        return i;
    }

    private void writeInt32(DataOutputStream output, Integer i) throws IOException {
        if (i == null) {
            output.writeInt(Integer.MIN_VALUE);
        } else {
            if (i == Integer.MIN_VALUE) {
                throw new SerializationException("Underflow: attempt to store -2147483648 in int32, but minimum value is 2147483647.");
            }
            output.writeInt(i);
        }
    }

    private Long readInt64(DataInputStream stream) throws IOException {
        long l = stream.readLong();
        if (l == Long.MIN_VALUE) {
            return null;
        }
        return l;
    }

    private void writeInt64(DataOutputStream output, Long l) throws IOException {
        if (l == null) {
            output.writeLong(Long.MIN_VALUE);
        } else {
            if (l == Long.MIN_VALUE) {
                throw new SerializationException("Underflow: attempt to store -9223372036854775808 in int64, but minimum value is 9223372036854775807.");
            }
            output.writeLong(l);
        }
    }

    private Float readFloat32(DataInputStream stream) throws IOException {
        float f = stream.readFloat();
        if (f == Float.MIN_VALUE) {
            return null;
        }
        return Float.valueOf(f);
    }

    private void writeFloat32(DataOutputStream output, Float f) throws IOException {
        if (f == null) {
            output.writeFloat(Float.MIN_VALUE);
        } else {
            if (f.floatValue() == Float.MIN_VALUE) {
                throw new SerializationException("Underflow: attempt to store 1.4E-45 in float32, but that value is reserved for null.");
            }
            output.writeFloat(f.floatValue());
        }
    }

    private Double readFloat64(DataInputStream stream) throws IOException {
        double d = stream.readDouble();
        if (d == Double.MIN_VALUE) {
            return null;
        }
        return d;
    }

    private void writeFloat64(DataOutputStream output, Double d) throws IOException {
        if (d == null) {
            output.writeDouble(Double.MIN_VALUE);
        } else {
            if (d == Double.MIN_VALUE) {
                throw new SerializationException("Underflow: attempt to store 4.9E-324 in float64, but that value is reserved for null.");
            }
            output.writeDouble(d);
        }
    }

    private Date coerceToDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Number) {
            return new Date(((Number)o).longValue());
        }
        throw new SerializationException("Object of type " + o.getClass() + " can not be coerced to type " + (Object)((Object)JsonTypes.DATE));
    }

    private Date readDate(DataInputStream stream) throws IOException {
        long l = stream.readLong();
        if (l == Long.MIN_VALUE) {
            return null;
        }
        return new Date(l);
    }

    private void writeDate(DataOutputStream output, Date d) throws IOException {
        if (d == null) {
            output.writeLong(Long.MIN_VALUE);
        } else {
            if (d.getTime() == Long.MIN_VALUE) {
                throw new SerializationException("Underflow: attempt to store " + new Date(Long.MIN_VALUE) + " in date, but that value is reserved for null.");
            }
            output.writeLong(d.getTime());
        }
    }

    private byte[] readBytes(DataInputStream stream) throws IOException {
        int size = this.readLength(stream);
        if (size < 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        ByteUtils.read(stream, bytes);
        return bytes;
    }

    private void writeBytes(DataOutputStream output, byte[] b) throws IOException {
        if (b == null) {
            this.writeLength(output, -1);
        } else {
            this.writeLength(output, b.length);
            output.write(b);
        }
    }

    private void writeMap(DataOutputStream output, Map<String, Object> object, Map<String, Object> type) throws IOException {
        if (object == null) {
            output.writeByte(-1);
            return;
        }
        output.writeByte(1);
        if (object.size() != type.size()) {
            throw new SerializationException("Invalid map for serialization, expected: " + type + " but got " + object);
        }
        for (Map.Entry<String, Object> entry : type.entrySet()) {
            if (!object.containsKey(entry.getKey())) {
                throw new SerializationException("Missing property: " + entry.getKey() + " that is required by the type (" + type + ")");
            }
            try {
                this.write(output, object.get(entry.getKey()), entry.getValue());
            }
            catch (SerializationException e) {
                throw new SerializationException("Fail to write property: " + entry.getKey(), e);
            }
        }
    }

    private Map<?, ?> readMap(DataInputStream stream, Map<String, Object> type) throws IOException {
        if (stream.readByte() == -1) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>(type.size());
        for (Map.Entry<String, Object> typeMapEntry : type.entrySet()) {
            m.put(typeMapEntry.getKey(), this.read(stream, typeMapEntry.getValue()));
        }
        return m;
    }

    private void writeList(DataOutputStream output, List<Object> objects, List<Object> type) throws IOException {
        if (type.size() != 1) {
            throw new SerializationException("Invalid type: expected single value type in list: " + type);
        }
        Object entryType = type.get(0);
        if (objects == null) {
            this.writeLength(output, -1);
        } else {
            this.writeLength(output, objects.size());
            for (Object o : objects) {
                this.write(output, o, entryType);
            }
        }
    }

    private List<?> readList(DataInputStream stream, List<?> type) throws IOException {
        int size = this.readLength(stream);
        if (size < 0) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>(size);
        Object entryType = type.get(0);
        for (int i = 0; i < size; ++i) {
            items.add(this.read(stream, entryType));
        }
        return items;
    }

    private void writeLength(DataOutputStream stream, int size) throws IOException {
        if (size < Short.MAX_VALUE) {
            stream.writeShort(size);
        } else if (size <= 0x3FFFFFFF) {
            stream.writeInt(size | 0xC0000000);
        } else {
            throw new SerializationException("Invalid length: maximum is 1073741823");
        }
    }

    int readLength(DataInputStream stream) throws IOException {
        short size = stream.readShort();
        if (size == -1) {
            return -1;
        }
        if (size < -1) {
            int fixedSize = size & 0x3FFF;
            fixedSize <<= 16;
            return fixedSize += stream.readShort() & 0xFFFF;
        }
        return size;
    }
}

