/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import voldemort.serialization.SerializationException;
import voldemort.serialization.SerializationUtils;
import voldemort.serialization.Serializer;
import voldemort.serialization.avro.AvroUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroSpecificSerializer<T extends SpecificRecord>
implements Serializer<T> {
    private final Class<T> clazz;

    public AvroSpecificSerializer(String schemaInfo) {
        try {
            this.clazz = Class.forName(SerializationUtils.getJavaClassFromSchemaInfo(schemaInfo));
            if (!SpecificRecord.class.isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException("Class provided should implement SpecificRecord");
            }
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public byte[] toBytes(T object) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataFileWriter writer = null;
        try {
            SpecificDatumWriter datumWriter = new SpecificDatumWriter(this.clazz);
            writer = new DataFileWriter((DatumWriter)datumWriter).create(SpecificData.get().getSchema(this.clazz), (OutputStream)output);
            writer.append(object);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            AvroUtils.close(writer);
        }
        return output.toByteArray();
    }

    @Override
    public T toObject(byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        DataFileStream reader = null;
        try {
            SpecificDatumReader datumReader = new SpecificDatumReader(this.clazz);
            reader = new DataFileStream((InputStream)input, (DatumReader)datumReader);
            SpecificRecord specificRecord = (SpecificRecord)reader.next();
            return (T)specificRecord;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            AvroUtils.close(reader);
        }
    }
}

