/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import voldemort.serialization.SerializationException;
import voldemort.serialization.SerializationUtils;
import voldemort.serialization.Serializer;
import voldemort.serialization.avro.AvroUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroReflectiveSerializer<T>
implements Serializer<T> {
    private final Class<T> clazz;

    public AvroReflectiveSerializer(String schemaInfo) {
        try {
            this.clazz = Class.forName(SerializationUtils.getJavaClassFromSchemaInfo(schemaInfo));
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public byte[] toBytes(T object) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataFileWriter writer = null;
        try {
            ReflectDatumWriter datumWriter = new ReflectDatumWriter(this.clazz);
            writer = new DataFileWriter((DatumWriter)datumWriter).create(ReflectData.get().getSchema(this.clazz), (OutputStream)output);
            writer.append(object);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            AvroUtils.close(writer);
        }
        return output.toByteArray();
    }

    @Override
    public T toObject(byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        DataFileStream reader = null;
        try {
            ReflectDatumReader datumReader = new ReflectDatumReader(this.clazz);
            reader = new DataFileStream((InputStream)input, (DatumReader)datumReader);
            Object object = reader.next();
            return (T)object;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            AvroUtils.close(reader);
        }
    }
}

