/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import voldemort.serialization.SerializationException;
import voldemort.serialization.Serializer;
import voldemort.serialization.avro.AvroUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroGenericSerializer
implements Serializer<Object> {
    private final Schema typeDef;

    public AvroGenericSerializer(String schema) {
        this.typeDef = Schema.parse((String)schema);
    }

    @Override
    public byte[] toBytes(Object object) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataFileWriter writer = null;
        try {
            GenericDatumWriter datumWriter = new GenericDatumWriter(this.typeDef);
            writer = new DataFileWriter((DatumWriter)datumWriter).create(this.typeDef, (OutputStream)output);
            writer.append(object);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            AvroUtils.close(writer);
        }
        return output.toByteArray();
    }

    @Override
    public Object toObject(byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        DataFileStream reader = null;
        try {
            GenericDatumReader datumReader = new GenericDatumReader(this.typeDef);
            reader = new DataFileStream((InputStream)input, (DatumReader)datumReader);
            Object object = reader.next();
            return object;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            AvroUtils.close(reader);
        }
    }
}

