/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import voldemort.serialization.Compression;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializerDefinition {
    private final String name;
    private final Integer currentSchemaVersion;
    private final boolean hasVersion;
    private final Map<Integer, String> schemaInfoByVersion;
    private final Compression compression;

    public SerializerDefinition(String name) {
        this.name = Utils.notNull(name);
        this.currentSchemaVersion = -1;
        this.schemaInfoByVersion = new HashMap<Integer, String>();
        this.compression = null;
        this.hasVersion = true;
    }

    public SerializerDefinition(String name, String schemaInfo) {
        this.name = Utils.notNull(name);
        this.currentSchemaVersion = 0;
        this.schemaInfoByVersion = new HashMap<Integer, String>();
        this.schemaInfoByVersion.put(0, schemaInfo);
        this.compression = null;
        this.hasVersion = true;
    }

    public SerializerDefinition(String name, Map<Integer, String> schemaInfos, boolean hasVersion, Compression compression) {
        this.name = Utils.notNull(name);
        this.schemaInfoByVersion = new HashMap<Integer, String>();
        this.compression = compression;
        this.hasVersion = hasVersion;
        if (!hasVersion) {
            this.currentSchemaVersion = 0;
            if (schemaInfos.size() != 1) {
                throw new IllegalArgumentException("Schema version = none, but multiple schemas specified.");
            }
            String schema = schemaInfos.values().iterator().next();
            this.schemaInfoByVersion.put(0, schema);
        } else {
            int max = -1;
            for (Integer key : schemaInfos.keySet()) {
                if (key < 0) {
                    throw new IllegalArgumentException("Version cannot be less than 0.");
                }
                if (key > 127) {
                    throw new IllegalArgumentException("Version cannot be more than 127");
                }
                if (key > max) {
                    max = key;
                }
                this.schemaInfoByVersion.put(key, schemaInfos.get(key));
            }
            this.currentSchemaVersion = max;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getCurrentSchemaVersion() {
        if (this.currentSchemaVersion < 0) {
            throw new IllegalStateException("There is no schema info associated with this serializer definition.");
        }
        return this.currentSchemaVersion;
    }

    public Map<Integer, String> getAllSchemaInfoVersions() {
        return this.schemaInfoByVersion;
    }

    public boolean hasSchemaInfo() {
        return this.currentSchemaVersion >= 0;
    }

    public String getSchemaInfo(int version) {
        if (!this.schemaInfoByVersion.containsKey(version)) {
            throw new IllegalArgumentException("Unknown schema version " + version + ".");
        }
        return this.schemaInfoByVersion.get(version);
    }

    public String getCurrentSchemaInfo() {
        if (this.currentSchemaVersion < 0) {
            throw new IllegalStateException("There is no schema info associated with this serializer definition.");
        }
        return this.schemaInfoByVersion.get(this.currentSchemaVersion);
    }

    public boolean hasVersion() {
        return this.hasVersion;
    }

    public boolean hasCompression() {
        return this.compression != null;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != SerializerDefinition.class) {
            return false;
        }
        SerializerDefinition s = (SerializerDefinition)obj;
        return Objects.equal(this.getName(), s.getName()) && Objects.equal(this.schemaInfoByVersion, s.schemaInfoByVersion) && Objects.equal(this.compression, s.compression) && this.hasVersion == s.hasVersion();
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.schemaInfoByVersion, this.compression, this.hasVersion});
    }

    public String toString() {
        return "SerializerDefinition(name = " + this.name + ", schema-info = " + this.schemaInfoByVersion + ", compression = " + this.compression + ")";
    }
}

