/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import org.apache.commons.lang.StringUtils;

public class SerializationUtils {
    private static final String ONLY_JAVA_CLIENTS_SUPPORTED = "Only Java clients are supported currently, so the format of the schema-info should be: <schema-info>java=foo.Bar</schema-info> where foo.Bar is the fully qualified name of the message.";

    public static String getJavaClassFromSchemaInfo(String schemaInfo) {
        if (StringUtils.isEmpty(schemaInfo)) {
            throw new IllegalArgumentException("This serializer requires a non-empty schema-info.");
        }
        String[] languagePairs = StringUtils.split((String)schemaInfo, (char)',');
        if (languagePairs.length > 1) {
            throw new IllegalArgumentException(ONLY_JAVA_CLIENTS_SUPPORTED);
        }
        String[] javaPair = StringUtils.split((String)languagePairs[0], (char)'=');
        if (javaPair.length != 2 || !javaPair[0].trim().equals("java")) {
            throw new IllegalArgumentException(ONLY_JAVA_CLIENTS_SUPPORTED);
        }
        return javaPair[1].trim();
    }
}

