/*
 * Decompiled with CFR 0.152.
 */
package voldemort.routing;

import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.routing.ConsistentRoutingStrategy;
import voldemort.routing.RouteToAllStrategy;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyType;
import voldemort.store.StoreDefinition;

public class RoutingStrategyFactory {
    public RoutingStrategy updateRoutingStrategy(StoreDefinition storeDef, Cluster cluster) {
        if (RoutingStrategyType.CONSISTENT_STRATEGY.equals(storeDef.getRoutingStrategyType())) {
            return new ConsistentRoutingStrategy(cluster.getNodes(), storeDef.getReplicationFactor());
        }
        if (RoutingStrategyType.TO_ALL_STRATEGY.equals(storeDef.getRoutingStrategyType())) {
            return new RouteToAllStrategy(cluster.getNodes());
        }
        throw new VoldemortException("RoutingStrategyType:" + storeDef.getRoutingStrategyType() + " not handled by " + this.getClass());
    }
}

