/*
 * Decompiled with CFR 0.152.
 */
package voldemort.routing;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.utils.FnvHashFunction;
import voldemort.utils.HashFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistentRoutingStrategy
implements RoutingStrategy {
    private final int numReplicas;
    private final Node[] partitionToNode;
    private final HashFunction hash;

    public ConsistentRoutingStrategy(Collection<Node> nodes, int numReplicas) {
        this(new FnvHashFunction(), nodes, numReplicas);
    }

    public ConsistentRoutingStrategy(HashFunction hash, Collection<Node> nodes, int numReplicas) {
        this.numReplicas = numReplicas;
        this.hash = hash;
        TreeMap<Integer, Node> m = new TreeMap<Integer, Node>();
        for (Node n : nodes) {
            for (Integer partition : n.getPartitionIds()) {
                if (m.containsKey(partition)) {
                    throw new IllegalArgumentException("Duplicate partition id " + partition + " in cluster configuration " + nodes);
                }
                m.put(partition, n);
            }
        }
        this.partitionToNode = new Node[m.size()];
        for (int i = 0; i < m.size(); ++i) {
            if (!m.containsKey(i)) {
                throw new IllegalArgumentException("Invalid configuration, missing partition " + i);
            }
            this.partitionToNode[i] = (Node)m.get(i);
        }
    }

    private static int abs(int a) {
        if (a >= 0) {
            return a;
        }
        if (a != Integer.MIN_VALUE) {
            return -a;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public List<Node> routeRequest(byte[] key) {
        List<Integer> partitionList = this.getPartitionList(key);
        if (partitionList.size() == 0) {
            return new ArrayList<Node>(0);
        }
        ArrayList<Node> preferenceList = new ArrayList<Node>(partitionList.size());
        for (int partition : partitionList) {
            preferenceList.add(this.partitionToNode[partition]);
        }
        return preferenceList;
    }

    @Override
    public List<Integer> getReplicatingPartitionList(int index) {
        ArrayList<Node> preferenceList = new ArrayList<Node>(this.numReplicas);
        ArrayList<Integer> replicationPartitionsList = new ArrayList<Integer>(this.numReplicas);
        if (this.partitionToNode.length == 0) {
            return new ArrayList<Integer>(0);
        }
        for (int i = 0; i < this.partitionToNode.length; ++i) {
            if (!preferenceList.contains(this.partitionToNode[index])) {
                preferenceList.add(this.partitionToNode[index]);
                replicationPartitionsList.add(index);
            }
            if (preferenceList.size() >= this.numReplicas) {
                return replicationPartitionsList;
            }
            index = (index + 1) % this.partitionToNode.length;
        }
        return replicationPartitionsList;
    }

    @Override
    public Set<Node> getNodes() {
        HashSet<Node> s = Sets.newHashSetWithExpectedSize(this.partitionToNode.length);
        for (Node n : this.partitionToNode) {
            s.add(n);
        }
        return s;
    }

    Node getNodeByPartition(int partition) {
        return this.partitionToNode[partition];
    }

    Set<Integer> getPartitionsByNode(Node n) {
        HashSet<Integer> tags = new HashSet<Integer>();
        for (int i = 0; i < this.partitionToNode.length; ++i) {
            if (!this.partitionToNode[i].equals(n)) continue;
            tags.add(i);
        }
        return tags;
    }

    @Override
    public List<Integer> getPartitionList(byte[] key) {
        int index = ConsistentRoutingStrategy.abs(this.hash.hash(key)) % Math.max(1, this.partitionToNode.length);
        return this.getReplicatingPartitionList(index);
    }
}

