/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.AsyncRecoveryFailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.NodeStatus;
import voldemort.store.UnreachableStoreException;

@JmxManaged(description="Detects the availability of the nodes on which a Voldemort cluster runs")
public class ThresholdFailureDetector
extends AsyncRecoveryFailureDetector {
    public ThresholdFailureDetector(FailureDetectorConfig failureDetectorConfig) {
        super(failureDetectorConfig);
    }

    public void recordException(Node node, long requestTime, UnreachableStoreException e) {
        this.checkArgs(node, requestTime);
        this.update(node, 0, e);
    }

    public void recordSuccess(Node node, long requestTime) {
        this.checkArgs(node, requestTime);
        int successDelta = 1;
        UnreachableStoreException e = null;
        if (requestTime > this.getConfig().getRequestLengthThreshold()) {
            e = new UnreachableStoreException("Node " + node.getId() + " recording success, but request time (" + requestTime + ") exceeded threshold (" + this.getConfig().getRequestLengthThreshold() + ")");
            successDelta = 0;
        }
        this.update(node, successDelta, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxGetter(name="nodeThresholdStats", description="Each node is listed with its status (available/unavailable) and success percentage")
    public String getNodeThresholdStats() {
        ArrayList<String> list = new ArrayList<String>();
        for (Node node : this.getConfig().getNodes()) {
            NodeStatus nodeStatus = this.getNodeStatus(node);
            boolean isAvailabile = false;
            long percentage = 0L;
            NodeStatus nodeStatus2 = nodeStatus;
            synchronized (nodeStatus2) {
                isAvailabile = nodeStatus.isAvailable();
                percentage = nodeStatus.getTotal() > 0L ? nodeStatus.getSuccess() * 100L / nodeStatus.getTotal() : 0L;
            }
            list.add(node.getId() + ",status=" + (isAvailabile ? "available" : "unavailable") + ",percentage=" + percentage + "%");
        }
        return StringUtils.join(list, (String)";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nodeRecovered(Node node) {
        NodeStatus nodeStatus;
        NodeStatus nodeStatus2 = nodeStatus = this.getNodeStatus(node);
        synchronized (nodeStatus2) {
            nodeStatus.setStartMillis(this.getConfig().getTime().getMilliseconds());
            nodeStatus.setSuccess(0L);
            nodeStatus.setTotal(0L);
            super.nodeRecovered(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Node node, int successDelta, UnreachableStoreException e) {
        NodeStatus nodeStatus;
        if (this.logger.isTraceEnabled()) {
            if (e != null) {
                this.logger.trace("Node " + node.getId() + " updated, successDelta: " + successDelta, e);
            } else {
                this.logger.trace("Node " + node.getId() + " updated, successDelta: " + successDelta);
            }
        }
        long currentTime = this.getConfig().getTime().getMilliseconds();
        String catastrophicError = this.getCatastrophicError(e);
        NodeStatus nodeStatus2 = nodeStatus = this.getNodeStatus(node);
        synchronized (nodeStatus2) {
            if (currentTime >= nodeStatus.getStartMillis() + this.getConfig().getThresholdInterval()) {
                nodeStatus.setStartMillis(currentTime);
                nodeStatus.setSuccess(successDelta);
                nodeStatus.setTotal(1L);
            } else {
                nodeStatus.incrementSuccess(successDelta);
                nodeStatus.incrementTotal(1L);
                if (catastrophicError != null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Node " + node.getId() + " experienced catastrophic error: " + catastrophicError);
                    }
                    this.setUnavailable(node, e);
                } else if (nodeStatus.getTotal() >= (long)this.getConfig().getThresholdCountMinimum()) {
                    long percentage = nodeStatus.getSuccess() * 100L / nodeStatus.getTotal();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Node " + node.getId() + " percentage: " + percentage + "%");
                    }
                    if (percentage >= (long)this.getConfig().getThreshold()) {
                        this.setAvailable(node);
                    } else {
                        this.setUnavailable(node, e);
                    }
                }
            }
        }
    }

    protected String getCatastrophicError(UnreachableStoreException e) {
        Throwable t;
        Throwable throwable = t = e != null ? e.getCause() : null;
        if (t == null) {
            return null;
        }
        for (String errorType : this.getConfig().getCatastrophicErrorTypes()) {
            if (!t.getClass().getName().equals(errorType)) continue;
            return errorType;
        }
        return null;
    }
}

