/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import java.util.HashMap;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.StoreVerifier;
import voldemort.server.VoldemortConfig;
import voldemort.store.Store;
import voldemort.store.UnreachableStoreException;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketPool;
import voldemort.store.socket.SocketStore;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;

public class ServerStoreVerifier
implements StoreVerifier {
    private final SocketPool socketPool;
    private final MetadataStore metadataStore;
    private final VoldemortConfig voldemortConfig;
    private final Map<Integer, Store<ByteArray, byte[]>> stores;

    public ServerStoreVerifier(SocketPool socketPool, MetadataStore metadataStore, VoldemortConfig voldemortConfig) {
        this.socketPool = Utils.notNull(socketPool);
        this.metadataStore = Utils.notNull(metadataStore);
        this.voldemortConfig = Utils.notNull(voldemortConfig);
        this.stores = new HashMap<Integer, Store<ByteArray, byte[]>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyStore(Node node) throws UnreachableStoreException, VoldemortException {
        Store<ByteArray, byte[]> store = null;
        if (node.getId() == this.voldemortConfig.getNodeId()) {
            store = this.metadataStore;
        } else {
            Map<Integer, Store<ByteArray, byte[]>> map = this.stores;
            synchronized (map) {
                store = this.stores.get(node.getId());
                if (store == null) {
                    store = new SocketStore("metadata", new SocketDestination(node.getHost(), node.getSocketPort(), this.voldemortConfig.getRequestFormatType()), this.socketPool, false);
                    this.stores.put(node.getId(), store);
                }
            }
        }
        store.get(KEY);
    }
}

