/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.cluster.Node;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="Metadata about the physical servers on which the Voldemort cluster runs")
@Threadsafe
public class Cluster
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int numberOfTags;
    private final Map<Integer, Node> nodesById;

    public Cluster(String name, List<Node> nodes) {
        this.name = Utils.notNull(name);
        this.nodesById = new LinkedHashMap<Integer, Node>(nodes.size());
        for (Node node : nodes) {
            if (this.nodesById.containsKey(node.getId())) {
                throw new IllegalArgumentException("Node id " + node.getId() + " appears twice in the node list.");
            }
            this.nodesById.put(node.getId(), node);
        }
        this.numberOfTags = this.getNumberOfTags(nodes);
    }

    private int getNumberOfTags(List<Node> nodes) {
        ArrayList<Integer> tags = new ArrayList<Integer>();
        for (Node node : nodes) {
            tags.addAll(node.getPartitionIds());
        }
        Collections.sort(tags);
        for (int i = 0; i < this.numberOfTags; ++i) {
            if ((Integer)tags.get(i) == i) continue;
            throw new IllegalArgumentException("Invalid tag assignment.");
        }
        return tags.size();
    }

    @JmxGetter(name="name", description="The name of the cluster")
    public String getName() {
        return this.name;
    }

    public Collection<Node> getNodes() {
        return this.nodesById.values();
    }

    public Node getNodeById(int id) {
        Node node = this.nodesById.get(id);
        if (node == null) {
            throw new VoldemortException("No such node in cluster: " + id);
        }
        return node;
    }

    @JmxGetter(name="numberOfNodes", description="The number of nodes in the cluster.")
    public int getNumberOfNodes() {
        return this.nodesById.size();
    }

    public int getNumberOfPartitions() {
        return this.numberOfTags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cluster('");
        builder.append(this.getName());
        builder.append("', [");
        for (Node n : this.getNodes()) {
            builder.append(n.toString());
            builder.append(", ");
        }
        builder.append("])");
        return builder.toString();
    }

    public boolean equals(Object second) {
        if (this == second) {
            return true;
        }
        if (second == null || second.getClass() != this.getClass()) {
            return false;
        }
        Cluster secondCluster = (Cluster)second;
        if (this.getNodes().size() != secondCluster.getNodes().size()) {
            return false;
        }
        for (Node nodeA : this.getNodes()) {
            Node nodeB = secondCluster.getNodeById(nodeA.getId());
            if (nodeA.getNumberOfPartitions() != nodeB.getNumberOfPartitions()) {
                return false;
            }
            if (Sets.newHashSet(nodeA.getPartitionIds()).equals(Sets.newHashSet(nodeB.getPartitionIds()))) continue;
            return false;
        }
        return true;
    }
}

